/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.dsync.common.util;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharsetUtil {
    private static final Logger log = LoggerFactory.getLogger(CharsetUtil.class);
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String byteToString(ByteBuf byteBuf, int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = byteBuf.readChar();
            if (c == '\u0000') continue;
            System.out.println(c);
            builder.append(c);
        }
        return builder.toString();
    }

    public static String byteToString(byte[] src) {
        int i;
        for (i = 0; i < src.length && src[i] != 0; ++i) {
        }
        try {
            return new String(src, 0, i, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Character Convert Failed", e);
            return null;
        }
    }

    public static byte[] stringToByte(String src) {
        return src.getBytes(UTF_8);
    }

    public static byte[] stringToByte(String src, int length) {
        byte[] s;
        byte[] d = new byte[length];
        System.arraycopy(s, 0, d, 0, (s = src.getBytes(UTF_8)).length >= length ? length : s.length);
        return d;
    }
}

