/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.dsync.example;

import cn.cyejing.dsync.toolkit.Config;
import cn.cyejing.dsync.toolkit.DLock;
import cn.cyejing.dsync.toolkit.DSync;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static DLock lock;

    public static void main(String[] args) throws Exception {
        Config config = Config.config();
        if (args.length > 1) {
            System.out.println("host: " + args[0]);
            config.host(args[0]);
        }
        DSync dSync = DSync.create(config);
        lock = dSync.getLock();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10);
        scheduledExecutorService.scheduleAtFixedRate(new Worker(), 3L, 20L, TimeUnit.SECONDS);
    }

    public static class Worker
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(Worker.class);
        ExecutorService executorService = Executors.newFixedThreadPool(10);

        @Override
        public void run() {
            int count = 5000;
            int[] i = new int[]{0};
            log.info("begin count:{}", (Object)count);
            CountDownLatch latch = new CountDownLatch(count);
            long start = System.currentTimeMillis();
            for (int j = 0; j < count; ++j) {
                this.executorService.submit(() -> {
                    try {
                        lock.lock("adder");
                        i[0] = i[0] + 1;
                        lock.unlock();
                    }
                    catch (Exception e) {
                        System.out.println("error");
                        e.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (i[0] == count) {
                log.info("worker cost:{}ms. result:{}", (Object)(System.currentTimeMillis() - start), (Object)i[0]);
            } else {
                log.error("ERROR worker cost:{}ms. result:{}", (Object)(System.currentTimeMillis() - start), (Object)i[0]);
            }
        }
    }
}

