/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.dsync.toolkit;

import cn.cyejing.dsync.common.handler.ResponseMessageToMessage;
import cn.cyejing.dsync.common.model.Request;
import cn.cyejing.dsync.common.model.Steps;
import cn.cyejing.dsync.toolkit.Config;
import com.alibaba.fastjson.JSON;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    protected String host;
    protected int port;
    protected EventLoopGroup group;
    protected Bootstrap bootstrap;
    protected Channel channel;

    public AbstractClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    protected void bootstrap() {
        this.group = new NioEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).option(ChannelOption.SO_KEEPALIVE, true)).channel(NioSocketChannel.class)).handler(new LoggingHandler(LogLevel.DEBUG))).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new IdleStateHandler(0, 0, 5), new StringEncoder(), new JsonObjectDecoder(), new ResponseMessageToMessage());
                AbstractClient.this.initSocketChannel(ch);
            }
        });
    }

    protected abstract ChannelHandler[] getChannelHandlers();

    public AbstractClient(Config config) {
        this(config.getHost(), config.getPort());
    }

    protected void doConnect() {
        if (this.channel != null && this.channel.isActive()) {
            return;
        }
        log.info("Connect to server: {}:{}", (Object)this.host, (Object)this.port);
        ChannelFuture future = this.bootstrap.connect(this.host, this.port);
        future.addListener(futureListener -> {
            if (futureListener.isSuccess()) {
                this.channel = futureListener.channel();
                Request define = new Request(-1L, -1L, Steps.Connect, null);
                this.channel.writeAndFlush(JSON.toJSONString(define));
                log.info("Connect to server successfully!");
            } else {
                log.warn("Failed to connect to server, try connect after 10s");
                futureListener.channel().eventLoop().schedule(() -> this.doConnect(), 10L, TimeUnit.SECONDS);
            }
        });
    }

    protected abstract void initSocketChannel(SocketChannel var1);
}

