/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.dsync.toolkit.lock;

import cn.cyejing.dsync.common.model.Request;
import cn.cyejing.dsync.common.model.Response;
import cn.cyejing.dsync.toolkit.AbstractClient;
import cn.cyejing.dsync.toolkit.Config;
import cn.cyejing.dsync.toolkit.lock.DLockImpl;
import com.alibaba.fastjson.JSON;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLockClient
extends AbstractClient {
    private static final Logger log = LoggerFactory.getLogger(DLockClient.class);
    private DLockImpl lock;

    public DLockClient(String host, int port, DLockImpl lock) {
        super(host, port);
        this.lock = lock;
    }

    public void connect() {
        this.bootstrap();
        this.doConnect();
    }

    public DLockClient(Config config, DLockImpl lock) {
        this(config.getHost(), config.getPort(), lock);
    }

    public void request(Request request) {
        this.channel.writeAndFlush(JSON.toJSONString(request));
    }

    @Override
    protected ChannelHandler[] getChannelHandlers() {
        return new ChannelHandler[]{new LockHandler(this.lock)};
    }

    @Override
    protected void initSocketChannel(SocketChannel channel) {
        channel.pipeline().addLast(new LockHandler(this.lock));
    }

    class LockHandler
    extends SimpleChannelInboundHandler<Response> {
        private DLockImpl lock;

        public LockHandler(DLockImpl lock) {
            this.lock = lock;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, Response res) throws Exception {
            switch (res.getOperate()) {
                case Connect: {
                    this.lock.revisionProcessId(res.getProcessId());
                    break;
                }
                case Unlock: {
                    this.lock.countDown(res.getLockId(), res.getResource());
                    break;
                }
                default: {
                    log.debug("ignore unknown operate:{}", (Object)res.getOperate());
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            log.info("channelInactive");
            super.channelInactive(ctx);
            this.lock.serverBreak();
            DLockClient.this.doConnect();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            super.exceptionCaught(ctx, cause);
            log.error("exceptionCaught", cause);
        }
    }
}

