/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.dsync.toolkit.lock;

import cn.cyejing.dsync.common.model.Request;
import cn.cyejing.dsync.common.model.Steps;
import cn.cyejing.dsync.toolkit.Config;
import cn.cyejing.dsync.toolkit.DLock;
import cn.cyejing.dsync.toolkit.lock.DLockClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLockImpl
implements DLock {
    private static final Logger log = LoggerFactory.getLogger(DLockImpl.class);
    private DLockClient client;
    private volatile long processId;
    private volatile CountDownLatch initProcessLatch = new CountDownLatch(1);
    private ConcurrentHashMap<String, CountDownLatch> localLock = new ConcurrentHashMap();
    private ThreadLocal<Request> threadLocal = new ThreadLocal();
    private AtomicLong lockIdAdder = new AtomicLong(1L);

    public DLockImpl(Config config) {
        this.client = new DLockClient(config, this);
    }

    public void init() {
        this.client.connect();
    }

    @Override
    public void lock(String resource) {
        long processId = this.syncGetProcessId();
        if (this.threadLocal.get() != null) {
            return;
        }
        long lockId = this.createLockId();
        String key = lockId + "-" + resource;
        log.debug("put latch of key:{}", (Object)key);
        CountDownLatch latch = new CountDownLatch(1);
        this.localLock.put(key, latch);
        Request request = new Request(processId, lockId, Steps.Lock, resource);
        this.threadLocal.set(request);
        this.client.request(request);
        try {
            log.debug("lock key:{}", (Object)key);
            latch.await();
            if (this.processId == 0L) {
                log.warn("channel is inactive, try connect...");
                this.localLock.remove(key);
                this.threadLocal.remove();
                this.lock(resource);
            }
        }
        catch (InterruptedException e) {
            this.localLock.remove(key);
            this.threadLocal.remove();
            log.error("lock is interrupted", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unlock() {
        Request request = this.threadLocal.get();
        if (request == null) {
            log.warn("don't repeat unlock");
            return;
        }
        request.setOperate(Steps.Unlock);
        this.client.request(request);
        this.threadLocal.remove();
    }

    void revisionProcessId(long serverProcessId) {
        this.processId = serverProcessId;
        this.initProcessLatch.countDown();
        log.info("connection server success and revision processId:{}", (Object)this.processId);
    }

    void countDown(long lockId, String resource) {
        String key = lockId + "-" + resource;
        CountDownLatch latch = this.localLock.get(key);
        log.debug("count down key:{}, count:{}", (Object)key, (Object)latch);
        if (latch != null) {
            latch.countDown();
            this.localLock.remove(key);
        }
    }

    void serverBreak() {
        this.processId = 0L;
        this.initProcessLatch = new CountDownLatch(1);
        this.localLock.values().forEach(latch -> latch.countDown());
        this.localLock.clear();
    }

    private long syncGetProcessId() {
        try {
            if (this.processId == 0L) {
                log.debug("waiting for server response process  id");
                this.initProcessLatch.await();
            }
        }
        catch (InterruptedException e) {
            log.error("waiting for process  is interrupted", e);
            throw new RuntimeException(e);
        }
        return this.processId;
    }

    private long createLockId() {
        return this.lockIdAdder.getAndIncrement();
    }
}

