/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.ngrok.core;

import cn.cyejing.ngrok.core.MessageHandler;
import cn.cyejing.ngrok.core.NgrokClientException;
import cn.cyejing.ngrok.core.SocketFactory;
import cn.cyejing.ngrok.core.Tunnel;
import cn.cyejing.ngrok.core.WorkerPool;
import cn.cyejing.ngrok.core.woker.MessageListenerWorker;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NgrokClient {
    private static Logger log = LoggerFactory.getLogger(NgrokClient.class);
    private SSLSocket socket;
    private final SocketFactory socketFactory;
    private List<Tunnel> tunnels = new ArrayList<Tunnel>();

    public NgrokClient(String serverAddress, int serverPort) {
        this.socketFactory = new SocketFactory(serverAddress, serverPort);
    }

    public void start() {
        try {
            this.socket = this.socketFactory.build();
        }
        catch (NgrokClientException e) {
            log.error("Ngrok Start failed: ", (Throwable)e);
            return;
        }
        MessageHandler messageHandler = new MessageHandler(this.socket, this.socketFactory, this.tunnels);
        WorkerPool.submit(new MessageListenerWorker(messageHandler));
        messageHandler.sendAuth();
    }

    public List<Tunnel> getTunnels() {
        return this.tunnels;
    }

    public NgrokClient addTunnel(Tunnel tunnel) {
        this.tunnels.add(tunnel);
        return this;
    }
}

