/*
 * Decompiled with CFR 0.152.
 */
package cn.cyejing.ngrok.autoconfigure;

import cn.cyejing.ngrok.autoconfigure.NgrokProperties;
import cn.cyejing.ngrok.core.NgrokClient;
import cn.cyejing.ngrok.core.Tunnel;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationListener;

public class NgrokEmbeddedServletContainerInitializedEventListener
implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private final NgrokProperties ngrokProperties;

    public NgrokEmbeddedServletContainerInitializedEventListener(NgrokProperties ngrokProperties) {
        this.ngrokProperties = ngrokProperties;
    }

    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        int port = event.getSource().getPort();
        String serverAddress = this.ngrokProperties.getServerAddress();
        int serverPort = this.ngrokProperties.getServerPort();
        String subdomain = this.ngrokProperties.getSubdomain();
        String hostname = this.ngrokProperties.getHostname();
        String proto = this.ngrokProperties.getProto();
        int remotePort = this.ngrokProperties.getRemotePort();
        String httpAuth = this.ngrokProperties.getHttpAuth();
        Tunnel tunnel = new Tunnel.TunnelBuild().setPort(port).setProto(proto).setSubDomain(subdomain).setHostname(hostname).setRemotePort(remotePort).setHttpAuth(httpAuth).build();
        new NgrokClient(serverAddress, serverPort).addTunnel(tunnel).start();
    }
}

