/*
 * Decompiled with CFR 0.152.
 */
package cn.detachment.notification.support.impl;

import cn.detachment.notification.beans.MailInfo;
import cn.detachment.notification.support.MailUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MailUtilImpl
implements MailUtil {
    private Transport transport;
    private Session session;
    private static Logger logger = LoggerFactory.getLogger(MailUtilImpl.class);

    public MailUtilImpl(Transport transport, Session session) {
        this.transport = transport;
        this.session = session;
    }

    @Override
    public void sendMsg(MailInfo mailInfo) {
        if (this.transport.isConnected()) {
            try {
                MimeMessage message = this.createMimeMessage(mailInfo);
                this.transport.sendMessage((Message)message, message.getAllRecipients());
            }
            catch (Exception e) {
                logger.error(" send email failed ,  " + e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error(" send email failed , transport has bean closed! ");
        }
    }

    @Override
    public MimeMessage createMimeMessage(MailInfo mailInfo) throws UnsupportedEncodingException, MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.session);
        InternetAddress address = new InternetAddress(mailInfo.getFrom(), "detachment", "UTF-8");
        mimeMessage.setFrom((Address)address);
        mimeMessage.setSubject(mailInfo.getSubject());
        mimeMessage.setRecipients(MimeMessage.RecipientType.TO, (Address[])this.getAddressFromList(mailInfo.getTo()));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart contentPart = new MimeBodyPart();
        contentPart.setContent((Object)mailInfo.getContent(), "text/html;charset=UTF-8");
        multipart.addBodyPart((BodyPart)contentPart);
        if (!CollectionUtils.isEmpty(mailInfo.getAttachments())) {
            this.fileAttachment(mailInfo.getAttachments()).stream().forEach(arg_0 -> MailUtilImpl.lambda$createMimeMessage$0((Multipart)multipart, arg_0));
        }
        mimeMessage.setContent((Multipart)multipart);
        return mimeMessage;
    }

    public List<BodyPart> fileAttachment(List<String> fp) {
        if (CollectionUtils.isEmpty(fp)) {
            return new ArrayList<BodyPart>();
        }
        return fp.stream().map(File::new).filter(File::exists).map(file -> new DataHandler((DataSource)new FileDataSource(file))).map(this::filePart).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BodyPart filePart(DataHandler dataHandler) {
        MimeBodyPart attachmentBodyPart = new MimeBodyPart();
        try {
            attachmentBodyPart.setDataHandler(dataHandler);
            attachmentBodyPart.setFileName(dataHandler.getName());
            return attachmentBodyPart;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private InternetAddress[] getAddressFromList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new RuntimeException("unsupported param!");
        }
        List<InternetAddress> internetAddresses = list.stream().map(s -> {
            try {
                return new InternetAddress(s, s, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        InternetAddress[] addresses = new InternetAddress[internetAddresses.size()];
        return internetAddresses.toArray(addresses);
    }

    private static /* synthetic */ void lambda$createMimeMessage$0(Multipart multipart, BodyPart part) {
        try {
            multipart.addBodyPart(part);
        }
        catch (MessagingException e) {
            logger.error("add file attachment failed! " + e.getMessage(), (Throwable)e);
        }
    }
}

