/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import nbcp.comm.ApiResult;
import nbcp.comm.JsonMap;
import nbcp.comm.MyHelper;
import nbcp.comm.MyJson;
import nbcp.comm.StringMap;
import nbcp.db.CacheKey;
import nbcp.db.CacheKeyTypeEnum;
import nbcp.db.DataCache4SqlService;
import nbcp.db.ProxyDataCache4SqlServiceImpl;
import nbcp.db.cache.ProxyCache4SqlService;
import nbcp.db.cache.UrkInfo;
import nbcp.db.db;
import nbcp.db.sql.DeleteSqlSect;
import nbcp.db.sql.FromSqlSect;
import nbcp.db.sql.InsertSqlSect;
import nbcp.db.sql.SingleSqlData;
import nbcp.db.sql.SqlBaseMetaTable;
import nbcp.db.sql.SqlBaseSect;
import nbcp.db.sql.SqlKeyEnum;
import nbcp.db.sql.SqlTokenAnalysor;
import nbcp.db.sql.UpdateSqlSect;
import nbcp.db.sql.WhereSqlSect;
import nbcp.utils.Md5Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-2147483647)
@DependsOn(value={"springUtil"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0012\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u001cH\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0012\u001a\u00020\fH\u0016J,\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J?\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010-\u001a\u00020.2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f04042\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00108\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u00109\u001a\u00020\u000eH\u0016J\u0018\u0010:\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\fH\u0016J\u0010\u0010<\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006="}, d2={"Lnbcp/db/ProxyDataCache4SqlServiceImpl;", "Lnbcp/db/cache/ProxyCache4SqlService;", "()V", "redisCache", "Lnbcp/db/DataCache4SqlService;", "getRedisCache", "()Lnbcp/db/DataCache4SqlService;", "redisCache$delegate", "Lkotlin/Lazy;", "clear", "", "tableName", "", "columnBelongTable", "", "column", "tableAlias", "delete4BrokeCache", "sql", "Lnbcp/db/sql/SingleSqlData;", "getCacheJson", "cacheKey", "Lnbcp/db/CacheKey;", "getCacheKey", "getColumnName", "getDeleteByRegion_BrokeCache", "", "regionValue", "Lnbcp/comm/StringMap;", "getFromJoinTables", "getFromTables", "getJoinTables", "getUnquoteName", "it", "getUpdateByRegion_BrokeCache", "getUpdateDeleteById_BrokeCache", "idJson", "getUpdateDeleteByReginUnion_BrokeCache", "idValue", "getUpdateDelete_BrokeCache", "getUpdateTable", "getUrkInfo", "Lnbcp/db/cache/UrkInfo;", "dbTable", "Lnbcp/db/sql/SqlBaseMetaTable;", "where", "Lnbcp/db/sql/WhereSqlSect;", "parameters", "Lnbcp/comm/JsonMap;", "getWhereMap", "Lnbcp/comm/ApiResult;", "rks", "", "(Lnbcp/db/sql/WhereSqlSect;[[Ljava/lang/String;Ljava/lang/String;Lnbcp/comm/JsonMap;)Lnbcp/comm/ApiResult;", "insert4BrokeCache", "insertMany4BrokeCache", "insertSelect4BrokeCache", "isEnable", "setCacheJson", "cacheJson", "updated4BrokeCache", "ktmyoql"})
public class ProxyDataCache4SqlServiceImpl
implements ProxyCache4SqlService {
    private final Lazy redisCache$delegate = LazyKt.lazy((Function0)redisCache.2.INSTANCE);

    private DataCache4SqlService getRedisCache() {
        Lazy lazy = this.redisCache$delegate;
        ProxyDataCache4SqlServiceImpl proxyDataCache4SqlServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DataCache4SqlService)lazy.getValue();
    }

    @Override
    public boolean isEnable() {
        return false;
    }

    @NotNull
    public Set<String> getFromTables(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String string = "\\bfrom\\b\\s*([^\\s]+\\s*\\.\\s*)?([^\\s]+)";
        Set set2 = SetsKt.setOf((Object[])new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL});
        boolean bl = false;
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)new Regex(string, set2).findAll((CharSequence)sql, 0), (Function1)getFromTables.1.INSTANCE), (Function1)getFromTables.2.INSTANCE));
    }

    @NotNull
    public Set<String> getJoinTables(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String string = "\\bjoin\\s+([^\\s]+\\s*\\.\\s*)?([^\\s]+)";
        Set set2 = SetsKt.setOf((Object[])new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL});
        boolean bl = false;
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)new Regex(string, set2).findAll((CharSequence)sql, 0), (Function1)getJoinTables.1.INSTANCE), (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ ProxyDataCache4SqlServiceImpl this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getUnquoteName(it);
            }
            {
                this.this$0 = proxyDataCache4SqlServiceImpl;
                super(1);
            }
        })));
    }

    @NotNull
    public Set<String> getFromJoinTables(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        boolean bl = false;
        HashSet set2 = new HashSet();
        set2.addAll(this.getFromTables(sql));
        set2.addAll(this.getJoinTables(sql));
        return set2;
    }

    @NotNull
    public String getUnquoteName(@Nullable String it) {
        if (it == null) {
            return "";
        }
        if (StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"]", (boolean)false, (int)2, null)) {
            return MyHelper.Slice((String)it, (int)1, (int)-1);
        }
        return it;
    }

    public boolean columnBelongTable(@NotNull String column, @NotNull String tableAlias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)tableAlias, (String)"tableAlias");
        return true;
    }

    @NotNull
    public String getColumnName(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return column;
    }

    @NotNull
    public ApiResult<StringMap> getWhereMap(@NotNull WhereSqlSect where, @NotNull String[][] rks, @NotNull String tableAlias, @NotNull JsonMap parameters) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)rks, (String)"rks");
        Intrinsics.checkNotNullParameter((Object)tableAlias, (String)"tableAlias");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        ApiResult ret = ApiResult.Companion.of((Object)new StringMap());
        for (WhereSqlSect cur_where = where; cur_where != null; cur_where = cur_where.getNext()) {
            if (!Intrinsics.areEqual((Object)cur_where.getLinker(), (Object)"or")) continue;
            ret.setMsg("or");
            return ret;
        }
        if (where.getChild() != null) {
            return ret;
        }
        if (Intrinsics.areEqual((Object)where.getOp(), (Object)"=")) {
            String left = where.getColumn();
            String right = where.getValue();
            Collection $this$Unwind$iv = ArraysKt.toList((Object[])((Object[])rks));
            boolean $i$f$Unwind = false;
            boolean bl = false;
            List list$iv = new ArrayList();
            Iterable $this$forEach$iv$iv = $this$Unwind$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Object[] it$iv = (Object[])element$iv$iv;
                boolean bl2 = false;
                Object[] $this$forEach$iv$iv2 = it$iv;
                boolean $i$f$forEach2 = false;
                Object[] objectArray = $this$forEach$iv$iv2;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv$iv2;
                    Object it$iv2 = element$iv$iv2 = objectArray[i];
                    boolean bl3 = false;
                    list$iv.add(it$iv2);
                }
            }
            Collection $this$toTypedArray$iv$iv = list$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] objectArray = thisCollection$iv$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] flatrks = objectArray;
            String columnName = this.getColumnName(left);
            String value = "";
            if (this.columnBelongTable(left, tableAlias)) {
                if (!ArraysKt.contains((Object[])flatrks, (Object)columnName)) {
                    return ret;
                }
                value = right;
            }
            if (MyHelper.getHasValue((String)value)) {
                if (StringsKt.startsWith$default((String)value, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"}", (boolean)false, (int)2, null)) {
                    ret.setData((Object)new StringMap(new Pair[]{TuplesKt.to((Object)columnName, (Object)MyHelper.AsString$default((Object)parameters.get((Object)MyHelper.Slice((String)value, (int)1, (int)-1)), null, (int)1, null))}));
                } else {
                    ret.setData((Object)new StringMap(new Pair[]{TuplesKt.to((Object)columnName, (Object)value)}));
                }
                return ret;
            }
        }
        if (where.getNext() != null) {
            Object object = ret.getData();
            Intrinsics.checkNotNull((Object)object);
            StringMap stringMap = (StringMap)object;
            WhereSqlSect whereSqlSect = where.getNext();
            Intrinsics.checkNotNull((Object)whereSqlSect);
            Object object2 = this.getWhereMap(whereSqlSect, rks, tableAlias, parameters).getData();
            Intrinsics.checkNotNull((Object)object2);
            stringMap.putAll((Map)object2);
        }
        return ret;
    }

    @Override
    @NotNull
    public CacheKey getCacheKey(@NotNull SingleSqlData sql) {
        boolean uksValid;
        boolean rksValid;
        StringMap uksValue;
        StringMap rksValue;
        CacheKey ret;
        block15: {
            boolean bl;
            boolean bl2;
            String[][] uks;
            block14: {
                SqlBaseMetaTable dbEntity;
                Object v1;
                String tableName;
                FromSqlSect from;
                block13: {
                    Object v0;
                    List<SqlBaseSect> analysor;
                    block12: {
                        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                        analysor = new SqlTokenAnalysor().analyse(sql.getExpression());
                        Iterable $this$firstOrNull$iv = analysor;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            SqlBaseSect it = (SqlBaseSect)element$iv;
                            boolean bl3 = false;
                            if (!(it.getKey() == SqlKeyEnum.From)) continue;
                            v0 = element$iv;
                            break block12;
                        }
                        v0 = null;
                    }
                    from = v0;
                    if (from == null) {
                        return CacheKey.Companion.empty();
                    }
                    tableName = this.getUnquoteName(from.getTableName());
                    Set<String> set2 = this.getFromJoinTables(sql.getExpression());
                    String md5 = Md5Util.INSTANCE.getBase64Md5(sql.getExpression() + "\n" + MyJson.ToJson$default((Object)sql.getValues(), null, (int)1, null));
                    ret = new CacheKey(CacheKeyTypeEnum.Normal, md5, tableName, set2, null, 16, null);
                    Iterable $this$firstOrNull$iv = analysor;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SqlBaseSect it = (SqlBaseSect)element$iv;
                        boolean bl4 = false;
                        if (!(it.getKey() == SqlKeyEnum.Where)) continue;
                        v1 = element$iv;
                        break block13;
                    }
                    v1 = null;
                }
                WhereSqlSect where = v1;
                if (where == null) {
                    return ret;
                }
                Function1<String, SqlBaseMetaTable<?>> function1 = db.INSTANCE.getSql().getGetSqlEntity();
                SqlBaseMetaTable sqlBaseMetaTable = dbEntity = function1 != null ? (SqlBaseMetaTable)function1.invoke((Object)tableName) : null;
                if (dbEntity == null) {
                    return ret;
                }
                SqlBaseMetaTable dbTable = dbEntity;
                String[][] rks = dbTable.getRks();
                uks = dbTable.getUks();
                String tableAlias = this.getUnquoteName(MyHelper.AsString((Object)from.getAlias(), (String)from.getTableName()));
                Object object = this.getWhereMap(where, rks, tableAlias, sql.getValues()).getData();
                Intrinsics.checkNotNull((Object)object);
                rksValue = (StringMap)object;
                Object object2 = this.getWhereMap(where, uks, tableAlias, sql.getValues()).getData();
                Intrinsics.checkNotNull((Object)object2);
                uksValue = (StringMap)object2;
                Object[] $this$any$iv = (Object[])rks;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Object[] it = (String[])element$iv;
                    boolean bl5 = false;
                    Set set3 = rksValue.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"rksValue.keys");
                    if (!(ArraysKt.intersect((Object[])it, (Iterable)set3).size() == it.length)) continue;
                    bl2 = true;
                    break block14;
                }
                bl2 = false;
            }
            rksValid = bl2;
            Object[] $this$any$iv = (Object[])uks;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Object[] it = (String[])element$iv;
                boolean bl6 = false;
                Set set4 = uksValue.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"uksValue.keys");
                if (!(ArraysKt.intersect((Object[])it, (Iterable)set4).size() == it.length)) continue;
                bl = true;
                break block15;
            }
            bl = uksValid = false;
        }
        if (rksValid && uksValid) {
            ret.setKey(CacheKeyTypeEnum.UnionReginKey);
            ret.getWhereJson().putAll((Map)uksValue);
            ret.getWhereJson().putAll((Map)rksValue);
        } else if (rksValid) {
            ret.setKey(CacheKeyTypeEnum.RegionKey);
            ret.getWhereJson().putAll((Map)rksValue);
        } else if (uksValid) {
            ret.setKey(CacheKeyTypeEnum.UnionKey);
            ret.getWhereJson().putAll((Map)uksValue);
        }
        return ret;
    }

    @Override
    @NotNull
    public String getCacheJson(@NotNull CacheKey cacheKey) {
        String ret;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        String string = this.getRedisCache().getCacheJson(cacheKey);
        if (string == null) {
            string = ret = "";
        }
        if (MyHelper.getHasValue((String)ret)) {
            return ret;
        }
        return "";
    }

    @Override
    public void setCacheJson(@NotNull CacheKey cacheKey, @NotNull String cacheJson) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)cacheJson, (String)"cacheJson");
        this.getRedisCache().setCacheJson(cacheKey, cacheJson);
    }

    @NotNull
    public UrkInfo getUrkInfo(@NotNull SqlBaseMetaTable<?> dbTable, @NotNull String tableAlias, @NotNull WhereSqlSect where, @NotNull JsonMap parameters) {
        boolean bl;
        boolean rksValid;
        StringMap uksValue;
        StringMap rksValue;
        block3: {
            boolean bl2;
            String[][] uks;
            block2: {
                Intrinsics.checkNotNullParameter(dbTable, (String)"dbTable");
                Intrinsics.checkNotNullParameter((Object)tableAlias, (String)"tableAlias");
                Intrinsics.checkNotNullParameter((Object)where, (String)"where");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                String[][] rks = dbTable.getRks();
                uks = dbTable.getUks();
                Object object = this.getWhereMap(where, rks, tableAlias, parameters).getData();
                Intrinsics.checkNotNull((Object)object);
                rksValue = (StringMap)object;
                Object object2 = this.getWhereMap(where, uks, tableAlias, parameters).getData();
                Intrinsics.checkNotNull((Object)object2);
                uksValue = (StringMap)object2;
                Object[] $this$any$iv = (Object[])rks;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Object[] it = (String[])element$iv;
                    boolean bl3 = false;
                    Set set2 = rksValue.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"rksValue.keys");
                    if (!(ArraysKt.intersect((Object[])it, (Iterable)set2).size() == it.length)) continue;
                    bl2 = true;
                    break block2;
                }
                bl2 = false;
            }
            rksValid = bl2;
            Object[] $this$any$iv = (Object[])uks;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Object[] it = (String[])element$iv;
                boolean bl4 = false;
                Set set3 = uksValue.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"uksValue.keys");
                if (!(ArraysKt.intersect((Object[])it, (Iterable)set3).size() == it.length)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        boolean uksValid = bl;
        return new UrkInfo(rksValue, uksValue, rksValid, uksValid);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getUpdateDeleteById_BrokeCache(@NotNull String tableName, @NotNull StringMap idJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)idJson, (String)"idJson");
        Map $this$map$iv = MapsKt.toSortedMap((Map)((Map)idJson));
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String valuePattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        if (MyHelper.getHasValue((String)valuePattern)) {
            valuePattern = "&" + valuePattern + "&*";
        }
        boolean bl3 = false;
        HashSet<String> ret = new HashSet<String>();
        ret.add("rk*-" + tableName + "-*");
        ret.add("uk*-" + tableName + "-*" + valuePattern);
        ret.add("urk*-" + tableName + "-*" + valuePattern);
        ret.add("sql*-" + tableName + "-*");
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getUpdateByRegion_BrokeCache(@NotNull String tableName, @NotNull StringMap regionValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)regionValue, (String)"regionValue");
        Map $this$map$iv = MapsKt.toSortedMap((Map)((Map)regionValue));
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String valuePattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        if (MyHelper.getHasValue((String)valuePattern)) {
            valuePattern = "&" + valuePattern + "&*";
        }
        boolean bl3 = false;
        HashSet<String> ret = new HashSet<String>();
        ret.add("uk*-" + tableName + "-*");
        ret.add("rk*-" + tableName + "-*" + valuePattern);
        ret.add("urk*-" + tableName + "-*" + valuePattern);
        ret.add("sql*-" + tableName + "-*");
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getDeleteByRegion_BrokeCache(@NotNull String tableName, @NotNull StringMap regionValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)regionValue, (String)"regionValue");
        Map $this$map$iv = MapsKt.toSortedMap((Map)((Map)regionValue));
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String valuePattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        if (MyHelper.getHasValue((String)valuePattern)) {
            valuePattern = "&" + valuePattern + "&*";
        }
        boolean bl3 = false;
        HashSet<String> ret = new HashSet<String>();
        ret.add("uk*-" + tableName + "-*");
        ret.add("rk*-" + tableName + "-*" + valuePattern);
        ret.add("urk*-" + tableName + "-*" + valuePattern);
        ret.add("sql*-" + tableName + "-*");
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getUpdateDeleteByReginUnion_BrokeCache(@NotNull String tableName, @NotNull StringMap regionValue, @NotNull StringMap idValue) {
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)regionValue, (String)"regionValue");
        Intrinsics.checkNotNullParameter((Object)idValue, (String)"idValue");
        Map $this$map$iv = MapsKt.toSortedMap((Map)((Map)regionValue));
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_12 = $this$mapTo$iv$iv2;
        boolean bl = false;
        Iterator iterator = var10_12.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String regionPattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        Map $this$map$iv2 = MapsKt.toSortedMap((Map)((Map)idValue));
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var11_15 = $this$mapTo$iv$iv;
        boolean bl3 = false;
        Iterator iterator2 = var11_15.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            string = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string);
        }
        String idPattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        if (MyHelper.getHasValue((String)regionPattern)) {
            regionPattern = "&" + regionPattern + "&*";
        }
        if (MyHelper.getHasValue((String)idPattern)) {
            idPattern = "&" + idPattern + "&*";
        }
        boolean bl5 = false;
        HashSet<String> ret = new HashSet<String>();
        ret.add("rk*-" + tableName + "-*" + regionPattern);
        ret.add("uk*-" + tableName + "-*" + idPattern);
        ret.add("urk*-" + tableName + "-*" + idPattern);
        ret.add("sql*-" + tableName + "-*");
        return ret;
    }

    @NotNull
    public Set<String> getUpdateDelete_BrokeCache(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        boolean bl = false;
        HashSet<String> ret = new HashSet<String>();
        ret.add("uk*-" + tableName + "-*");
        ret.add("rk*-" + tableName + "-*");
        ret.add("urk*-" + tableName + "-*");
        ret.add("sql*-" + tableName + "-*");
        return ret;
    }

    @NotNull
    public Set<String> getUpdateTable(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String string = "\\bfrom\\b\\s*([^\\s]+\\s*\\.\\s*)?([^\\s]+)";
        Set set2 = SetsKt.setOf((Object[])new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL});
        boolean bl = false;
        return SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)new Regex(string, set2).findAll((CharSequence)sql, 0), (Function1)getUpdateTable.1.INSTANCE), (Function1)getUpdateTable.2.INSTANCE));
    }

    @Override
    public void updated4BrokeCache(@NotNull SingleSqlData sql) {
        SqlBaseMetaTable dbEntity;
        boolean bl;
        Object element$iv3;
        UpdateSqlSect update;
        block8: {
            Object element$iv22;
            List<SqlBaseSect> analysor;
            block7: {
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                if (!this.isEnable()) {
                    return;
                }
                analysor = new SqlTokenAnalysor().analyse(sql.getExpression());
                Iterable $this$first$iv = analysor;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    SqlBaseSect it = (SqlBaseSect)element$iv22;
                    boolean bl2 = false;
                    if (!(it.getKey() == SqlKeyEnum.Update)) continue;
                    break block7;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv22;
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.UpdateSqlSect");
            }
            update = (UpdateSqlSect)t;
            Iterable $this$first$iv = analysor;
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                SqlBaseSect it = (SqlBaseSect)element$iv3;
                bl = false;
                if (!(it.getKey() == SqlKeyEnum.Where)) continue;
                break block8;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object e = element$iv3;
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.WhereSqlSect");
        }
        WhereSqlSect where = (WhereSqlSect)e;
        String tableName = update.getTableName();
        String tableAlias = update.getAlias();
        Function1<String, SqlBaseMetaTable<?>> function1 = db.INSTANCE.getSql().getGetSqlEntity();
        SqlBaseMetaTable sqlBaseMetaTable = dbEntity = function1 != null ? (SqlBaseMetaTable)function1.invoke((Object)tableName) : null;
        if (dbEntity == null) {
            return;
        }
        UrkInfo urkInfo = this.getUrkInfo(dbEntity, this.getUnquoteName(MyHelper.AsString((Object)tableAlias, (String)tableName)), where, sql.getValues());
        bl = false;
        Set<String> set2 = SetsKt.emptySet();
        set2 = urkInfo.getRksValid() && urkInfo.getUksValid() ? this.getUpdateDeleteByReginUnion_BrokeCache(tableName, urkInfo.getRks(), urkInfo.getUks()) : (urkInfo.getRksValid() ? this.getUpdateByRegion_BrokeCache(tableName, urkInfo.getRks()) : (urkInfo.getUksValid() ? this.getUpdateDeleteById_BrokeCache(tableName, urkInfo.getUks()) : this.getUpdateDelete_BrokeCache(tableName)));
        int cacheSeconds = this.getRedisCache().getCacheSeconds(tableName);
        if (cacheSeconds > 0) {
            this.getRedisCache().brokeCache(tableName, set2);
        }
    }

    @Override
    public void delete4BrokeCache(@NotNull SingleSqlData sql) {
        SqlBaseMetaTable dbEntity;
        boolean bl;
        Object element$iv3;
        DeleteSqlSect delete;
        block8: {
            Object element$iv22;
            List<SqlBaseSect> analysor;
            block7: {
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                if (!this.isEnable()) {
                    return;
                }
                analysor = new SqlTokenAnalysor().analyse(sql.getExpression());
                Iterable $this$first$iv = analysor;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    SqlBaseSect it = (SqlBaseSect)element$iv22;
                    boolean bl2 = false;
                    if (!(it.getKey() == SqlKeyEnum.Delete)) continue;
                    break block7;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv22;
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.DeleteSqlSect");
            }
            delete = (DeleteSqlSect)t;
            Iterable $this$first$iv = analysor;
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                SqlBaseSect it = (SqlBaseSect)element$iv3;
                bl = false;
                if (!(it.getKey() == SqlKeyEnum.Where)) continue;
                break block8;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object e = element$iv3;
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.WhereSqlSect");
        }
        WhereSqlSect where = (WhereSqlSect)e;
        String tableName = delete.getTableName();
        String tableAlias = delete.getAlias();
        Function1<String, SqlBaseMetaTable<?>> function1 = db.INSTANCE.getSql().getGetSqlEntity();
        SqlBaseMetaTable sqlBaseMetaTable = dbEntity = function1 != null ? (SqlBaseMetaTable)function1.invoke((Object)tableName) : null;
        if (dbEntity == null) {
            return;
        }
        UrkInfo urkInfo = this.getUrkInfo(dbEntity, tableAlias, where, sql.getValues());
        bl = false;
        Set<String> set2 = SetsKt.emptySet();
        set2 = urkInfo.getRksValid() && urkInfo.getUksValid() ? this.getUpdateDeleteByReginUnion_BrokeCache(tableName, urkInfo.getRks(), urkInfo.getUks()) : (urkInfo.getRksValid() ? this.getDeleteByRegion_BrokeCache(tableName, urkInfo.getRks()) : (urkInfo.getUksValid() ? this.getUpdateDeleteById_BrokeCache(tableName, urkInfo.getUks()) : this.getUpdateDelete_BrokeCache(tableName)));
        int cacheSeconds = this.getRedisCache().getCacheSeconds(tableName);
        if (cacheSeconds > 0) {
            this.getRedisCache().brokeCache(tableName, set2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insert4BrokeCache(@NotNull SingleSqlData sql) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object $this$forEach$iv$iv;
        SqlBaseMetaTable dbEntity;
        Object element$iv3;
        InsertSqlSect insert;
        block18: {
            Object element$iv22;
            List<SqlBaseSect> analysor;
            block17: {
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                if (!this.isEnable()) {
                    return;
                }
                analysor = new SqlTokenAnalysor().analyse(sql.getExpression());
                Iterable $this$first$iv = analysor;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    SqlBaseSect it = (SqlBaseSect)element$iv22;
                    boolean bl = false;
                    if (!(it.getKey() == SqlKeyEnum.Insert)) continue;
                    break block17;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv22;
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.InsertSqlSect");
            }
            insert = (InsertSqlSect)t;
            Iterable $this$first$iv = analysor;
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                SqlBaseSect it = (SqlBaseSect)element$iv3;
                boolean bl = false;
                if (!(it.getKey() == SqlKeyEnum.Where)) continue;
                break block18;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object e = element$iv3;
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type nbcp.db.sql.WhereSqlSect");
        }
        WhereSqlSect where = (WhereSqlSect)e;
        String tableName = insert.getTableName();
        Function1<String, SqlBaseMetaTable<?>> function1 = db.INSTANCE.getSql().getGetSqlEntity();
        SqlBaseMetaTable sqlBaseMetaTable = dbEntity = function1 != null ? (SqlBaseMetaTable)function1.invoke((Object)tableName) : null;
        if (dbEntity == null) {
            return;
        }
        SqlBaseMetaTable dbTable = dbEntity;
        String[][] rks = dbTable.getRks();
        Collection $this$Unwind$iv = ArraysKt.toList((Object[])((Object[])rks));
        boolean $i$f$Unwind = false;
        boolean bl = false;
        List list$iv = new ArrayList();
        Iterable $this$forEach$iv$iv2 = $this$Unwind$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv2) {
            Object[] it$iv = (Object[])element$iv$iv;
            boolean bl2 = false;
            $this$forEach$iv$iv = it$iv;
            boolean $i$f$forEach2 = false;
            Object[] objectArray = $this$forEach$iv$iv;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv$iv2;
                Object it$iv2 = element$iv$iv2 = objectArray[i];
                boolean bl3 = false;
                list$iv.add(it$iv2);
            }
        }
        String[] $this$toTypedArray$iv$iv = (String[])list$iv;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        String[] stringArray = thisCollection$iv$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = stringArray;
        String[] $this$map$iv = object;
        boolean $i$f$map = false;
        $this$toTypedArray$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Iterator item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $this$forEach$iv$iv = (String)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)it, (Object)sql.getValues().getOrDefault((Object)it, null));
            object.add(pair);
        }
        object = (List)destination$iv$iv;
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Pair[] pairArray2 = Arrays.copyOf(pairArray, pairArray.length);
        JsonMap rksValue = new JsonMap(pairArray2);
        $i$f$toTypedArray2 = false;
        HashSet<String> set2 = new HashSet<String>();
        Object[] $this$forEach$iv = (Object[])rks;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            Object[] group = (String[])element$iv4;
            boolean bl6 = false;
            Map $this$filterKeys$iv = (Map)rksValue;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map map2 = $this$filterKeys$iv;
            boolean bl7 = false;
            for (Map.Entry entry$iv : map2.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl8 = false;
                if (!ArraysKt.contains((Object[])group, (Object)it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map regionValue = result$iv;
            if (group.length != regionValue.size()) continue;
            Map $this$map$iv2 = MapsKt.toSortedMap((Map)regionValue);
            boolean $i$f$map2 = false;
            map2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            void var25_54 = $this$mapTo$iv$iv2;
            boolean bl9 = false;
            Iterator iterator = var25_54.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl10 = false;
                String string = (String)it.getKey() + '=' + it.getValue();
                collection.add(string);
            }
            String valuePattern = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            if (MyHelper.getHasValue((String)valuePattern)) {
                valuePattern = "&" + valuePattern + "&*";
            }
            set2.add("rk*-" + tableName + "-*" + valuePattern);
        }
        set2.add("sql*-" + tableName + "-*");
        int cacheSeconds = this.getRedisCache().getCacheSeconds(tableName);
        if (cacheSeconds > 0) {
            this.getRedisCache().brokeCache(tableName, (Set<String>)set2);
        }
    }

    @Override
    public void insertMany4BrokeCache(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        if (!this.isEnable()) {
            return;
        }
        boolean bl = false;
        Set set2 = new LinkedHashSet();
        set2.add("rk*-" + tableName + "-*");
        set2.add("sql*-" + tableName + "-*");
        int cacheSeconds = this.getRedisCache().getCacheSeconds(tableName);
        if (cacheSeconds > 0) {
            this.getRedisCache().brokeCache(tableName, set2);
        }
    }

    @Override
    public void insertSelect4BrokeCache(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        if (!this.isEnable()) {
            return;
        }
        Set set2 = SetsKt.setOf((Object[])new String[]{"rk*-" + tableName + "-*", "sql*-" + tableName + "-*"});
        int cacheSeconds = this.getRedisCache().getCacheSeconds(tableName);
        if (cacheSeconds > 0) {
            this.getRedisCache().brokeCache(tableName, set2);
        }
    }

    @Override
    public void clear(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.getRedisCache().clear(tableName);
    }
}

