/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nbcp.comm.MyHelper;
import nbcp.db.CacheKey;
import nbcp.db.CacheKeyTypeEnum;
import nbcp.db.DataCache4SqlService;
import nbcp.db.cache.DataCache4SqlServiceImpl;
import nbcp.db.db;
import nbcp.db.redis.RedisBaseGroup;
import nbcp.db.redis.proxy.RedisNumberProxy;
import nbcp.db.redis.proxy.RedisStringProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Service;

@Service(value="redis")
@ConfigurationProperties(prefix="sql-orm")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0017J\b\u0010\u001d\u001a\u00020\fH\u0016J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0005H\u0016R6\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lnbcp/db/cache/DataCache4SqlServiceImpl;", "Lnbcp/db/DataCache4SqlService;", "()V", "cacheDefine", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getCacheDefine", "()Ljava/util/LinkedHashMap;", "setCacheDefine", "(Ljava/util/LinkedHashMap;)V", "enable", "", "getEnable", "()Z", "enable$delegate", "Lkotlin/Lazy;", "brokeCache", "", "tableName", "keys", "", "clear", "getCacheJson", "cacheKey", "Lnbcp/db/CacheKey;", "getCacheSeconds", "", "init", "isEnable", "setCacheJson", "cacheJson", "Companion", "ktmyoql"})
public class DataCache4SqlServiceImpl
implements DataCache4SqlService {
    @NotNull
    private LinkedHashMap<String, String> cacheDefine;
    @NotNull
    private final Lazy enable$delegate;
    private static final Logger logger;
    private static final RedisBaseGroup rer_base;
    public static final Companion Companion;

    @NotNull
    public LinkedHashMap<String, String> getCacheDefine() {
        return this.cacheDefine;
    }

    public void setCacheDefine(@NotNull LinkedHashMap<String, String> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, (String)"<set-?>");
        this.cacheDefine = linkedHashMap;
    }

    public boolean getEnable() {
        Lazy lazy = this.enable$delegate;
        DataCache4SqlServiceImpl dataCache4SqlServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean isEnable() {
        return this.getEnable();
    }

    @PostConstruct
    public void init() {
        Set<String> set2 = this.getCacheDefine().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"cacheDefine.keys");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            CharSequence charSequence;
            String value;
            String key;
            block12: {
                block11: {
                    key = (String)element$iv;
                    boolean bl2 = false;
                    value = this.getCacheDefine().get(key);
                    if (value == null) break block11;
                    charSequence = value;
                    bl = false;
                    if (!(charSequence.length() == 0)) break block12;
                }
                this.getCacheDefine().remove(key);
                continue;
            }
            if (StringsKt.endsWith$default((String)value, (String)"s", (boolean)false, (int)2, null)) {
                Map map2 = this.getCacheDefine();
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                map2.put(string, MyHelper.Slice((String)value, (int)0, (int)-1));
            } else if (StringsKt.endsWith$default((String)value, (String)"m", (boolean)false, (int)2, null)) {
                Map map3 = this.getCacheDefine();
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                map3.put(string, String.valueOf(MyHelper.AsInt$default((Object)MyHelper.Slice((String)value, (int)0, (int)-1), (int)0, (int)1, null) * 60));
            } else if (StringsKt.endsWith$default((String)value, (String)"h", (boolean)false, (int)2, null)) {
                Map map4 = this.getCacheDefine();
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                map4.put(string, String.valueOf(MyHelper.AsInt$default((Object)MyHelper.Slice((String)value, (int)0, (int)-1), (int)0, (int)1, null) * 3600));
            } else if (StringsKt.endsWith$default((String)value, (String)"d", (boolean)false, (int)2, null)) {
                Map map5 = this.getCacheDefine();
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                map5.put(string, String.valueOf(MyHelper.AsInt$default((Object)MyHelper.Slice((String)value, (int)0, (int)-1), (int)0, (int)1, null) * 86400));
            }
            String string = value = this.getCacheDefine().get(key);
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
            bl = false;
            if (!(charSequence.length() == 0)) continue;
            this.getCacheDefine().remove(key);
        }
    }

    @Override
    public int getCacheSeconds(@Nullable String tableName) {
        block3: {
            block2: {
                if (tableName == null) break block2;
                CharSequence charSequence = tableName;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return 0;
        }
        return MyHelper.AsInt$default((Object)this.getCacheDefine().getOrDefault(tableName, ""), (int)0, (int)1, null);
    }

    @Override
    @NotNull
    public String getCacheJson(@NotNull CacheKey cacheKey) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            if (!this.isEnable()) {
                return "";
            }
            if (cacheKey.getKey() == CacheKeyTypeEnum.None) {
                return "";
            }
            if (this.getCacheSeconds(cacheKey.getTableName()) <= 0) {
                return "";
            }
            Iterable $this$any$iv = cacheKey.getDependencies();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(rer_base.getSqlCache().brokeKeys(it).size("") > 0)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return "";
        }
        String ret = rer_base.getSqlCache().getCacheSqlData().get(cacheKey.getExpression());
        CharSequence charSequence = ret;
        boolean bl3 = false;
        if (charSequence.length() > 0) {
            logger.info("\u547d\u4e2d\u7f13\u5b58\u6570\u636e: " + cacheKey);
        }
        return ret;
    }

    @Override
    public void setCacheJson(@NotNull CacheKey cacheKey, @NotNull String cacheJson) {
        boolean bl;
        int cacheSeconds;
        block7: {
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            Intrinsics.checkNotNullParameter((Object)cacheJson, (String)"cacheJson");
            if (!this.isEnable()) {
                return;
            }
            if (cacheKey.getKey() == CacheKeyTypeEnum.None) {
                return;
            }
            cacheSeconds = this.getCacheSeconds(cacheKey.getTableName());
            if (cacheSeconds <= 0) {
                return;
            }
            String brokingTable = RedisStringProxy.get$default(rer_base.getSqlCache().getBrokingTable(), null, 1, null);
            Iterable $this$any$iv = cacheKey.getDependencies();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)brokingTable, (Object)it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        rer_base.getSqlCache().getCacheSqlData().set(cacheKey.getExpression(), cacheJson, cacheSeconds);
    }

    @Override
    public void brokeCache(@NotNull String tableName, @NotNull Set<String> keys) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Collection $this$toTypedArray$iv = keys;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        rer_base.getSqlCache().brokeKeys(tableName).add("", Arrays.copyOf(stringArray, stringArray.length));
        RedisNumberProxy.increment$default(rer_base.getSqlCache().getBorkeKeysChangedVersion(), "", 0, 2, null);
    }

    @Override
    public void clear(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        CharSequence charSequence = tableName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        bl = false;
        HashSet<String> set2 = new HashSet<String>();
        set2.add("uk*-" + tableName + "-*");
        set2.add("rk*-" + tableName + "-*");
        set2.add("urk*-" + tableName + "-*");
        set2.add("sql*-" + tableName + "-*");
        this.brokeCache(tableName, (Set<String>)set2);
    }

    public DataCache4SqlServiceImpl() {
        boolean bl = false;
        this.cacheDefine = new LinkedHashMap();
        this.enable$delegate = LazyKt.lazy((Function0)enable.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Companion.getClass().getDeclaringClass());
        rer_base = db.INSTANCE.getRer_base();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnbcp/db/cache/DataCache4SqlServiceImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "rer_base", "Lnbcp/db/redis/RedisBaseGroup;", "ktmyoql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

