/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.cache;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import nbcp.comm.MyJson;
import nbcp.db.cache.CacheForBroke;
import nbcp.db.cache.CacheForSelect;
import nbcp.db.redis.RedisTask;
import nbcp.utils.Md5Util;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lnbcp/db/cache/RedisCacheIntercepter;", "", "()V", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "getRedisTemplate", "()Lorg/springframework/data/redis/core/StringRedisTemplate;", "setRedisTemplate", "(Lorg/springframework/data/redis/core/StringRedisTemplate;)V", "cacheBroke", "joinPoint", "Lorg/aspectj/lang/ProceedingJoinPoint;", "cacheSelect", "getCacheKey", "", "cache", "Lnbcp/db/cache/CacheForSelect;", "ext", "Companion", "ktmyoql"})
public class RedisCacheIntercepter {
    @Autowired
    @Lazy
    @NotNull
    public StringRedisTemplate redisTemplate;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public StringRedisTemplate getRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = this.redisTemplate;
        if (stringRedisTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"redisTemplate");
        }
        return stringRedisTemplate;
    }

    public void setRedisTemplate(@NotNull StringRedisTemplate stringRedisTemplate) {
        Intrinsics.checkNotNullParameter((Object)stringRedisTemplate, (String)"<set-?>");
        this.redisTemplate = stringRedisTemplate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getCacheKey(@NotNull CacheForSelect cache, @NotNull String ext) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        boolean bl = false;
        List list = new ArrayList();
        list.add(cache.key());
        list.add(cache.value());
        list.add(ext);
        String md5 = Md5Util.INSTANCE.getBase64Md5(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)MyHelper.getLine_break(), null, null, (int)0, null, null, (int)62, null));
        Iterable iterable = ArraysKt.toSortedSet((Comparable[])((Comparable[])cache.joinTables()));
        StringBuilder stringBuilder = new StringBuilder().append("sc:").append(cache.table()).append(':');
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = '[' + (String)it + ']';
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        String ret = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
        if (MyHelper.getHasValue((String)cache.key()) && MyHelper.getHasValue((String)cache.value())) {
            ret = ret + '(' + cache.key() + '-' + cache.value() + ')';
        }
        return ret + md5;
    }

    @Around(value="@annotation(nbcp.db.cache.CacheForSelect)")
    @Nullable
    public Object cacheSelect(@NotNull ProceedingJoinPoint joinPoint) {
        Object[] args;
        CacheForSelect cache;
        MethodSignature signature;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
                Signature signature2 = joinPoint.getSignature();
                if (signature2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
                }
                signature = (MethodSignature)signature2;
                Method method = signature.getMethod();
                Object[] objectArray = method.getAnnotationsByType(CacheForSelect.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.getAnnotationsByT\u2026cheForSelect::class.java)");
                cache = (CacheForSelect)ArraysKt.firstOrNull((Object[])objectArray);
                args = joinPoint.getArgs();
                if (cache == null) break block6;
                CharSequence charSequence = cache.table();
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return joinPoint.proceed(args);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Class clazz = signature.getDeclaringType();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"signature.declaringType");
        StringBuilder stringBuilder2 = stringBuilder.append(clazz.getName()).append(":");
        Object[] objectArray = signature.getParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"signature.parameterNames");
        String cacheKey = this.getCacheKey(cache, stringBuilder2.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        String cacheValue = MyHelper.AsString$default((Object)this.getRedisTemplate().opsForValue().get((Object)cacheKey), null, (int)1, null);
        if (MyHelper.getHasValue((String)cacheValue)) {
            Class clazz2 = signature.getReturnType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"signature.returnType");
            return MyJson.FromJson$default((String)cacheValue, (Class)clazz2, null, (int)2, null);
        }
        Object ret = joinPoint.proceed(args);
        if (ret != null) {
            this.getRedisTemplate().opsForValue().set((Object)cacheKey, (Object)MyJson.ToJson$default((Object)ret, null, (int)1, null), Duration.ofMinutes(15L));
        }
        return ret;
    }

    @Around(value="@annotation(nbcp.db.cache.CacheForBroke)")
    @Nullable
    public Object cacheBroke(@NotNull ProceedingJoinPoint joinPoint) {
        Object[] args;
        CacheForBroke cache;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
                Signature signature = joinPoint.getSignature();
                if (signature == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
                }
                MethodSignature signature2 = (MethodSignature)signature;
                Method method = signature2.getMethod();
                Object[] objectArray = method.getAnnotationsByType(CacheForBroke.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.getAnnotationsByT\u2026acheForBroke::class.java)");
                cache = (CacheForBroke)ArraysKt.firstOrNull((Object[])objectArray);
                args = joinPoint.getArgs();
                if (cache == null) break block4;
                CharSequence charSequence = cache.table();
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block5;
            }
            return joinPoint.proceed(args);
        }
        RedisTask.INSTANCE.setDelayBrokeCacheKey(cache);
        return joinPoint.proceed(args);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Companion.getClass().getDeclaringClass());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnbcp/db/cache/RedisCacheIntercepter$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ktmyoql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

