/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.mongo;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lnbcp/db/mongo/Date2LocalDateTimeConverter;", "Lorg/springframework/core/convert/converter/GenericConverter;", "()V", "convert", "", "value", "sourceType", "Lorg/springframework/core/convert/TypeDescriptor;", "targetType", "getConvertibleTypes", "", "Lorg/springframework/core/convert/converter/GenericConverter$ConvertiblePair;", "ktmyoql"})
public final class Date2LocalDateTimeConverter
implements GenericConverter {
    @NotNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        boolean bl = false;
        HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
        pairs.add(new GenericConverter.ConvertiblePair(String.class, LocalDate.class));
        pairs.add(new GenericConverter.ConvertiblePair(String.class, LocalTime.class));
        pairs.add(new GenericConverter.ConvertiblePair(String.class, LocalDateTime.class));
        pairs.add(new GenericConverter.ConvertiblePair(Date.class, LocalDate.class));
        pairs.add(new GenericConverter.ConvertiblePair(Date.class, LocalTime.class));
        pairs.add(new GenericConverter.ConvertiblePair(Date.class, LocalDateTime.class));
        pairs.add(new GenericConverter.ConvertiblePair(LocalDate.class, Date.class));
        pairs.add(new GenericConverter.ConvertiblePair(LocalTime.class, Date.class));
        pairs.add(new GenericConverter.ConvertiblePair(LocalDateTime.class, Date.class));
        return pairs;
    }

    @Nullable
    public Object convert(@Nullable Object value, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (value == null) {
            return null;
        }
        Class valueClass = sourceType.getType();
        Class targetClass = targetType.getType();
        if (Intrinsics.areEqual((Object)valueClass, String.class)) {
            String strValue = MyHelper.AsString$default((Object)value, null, (int)1, null);
            CharSequence charSequence = strValue;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return null;
            }
            if (Intrinsics.areEqual((Object)targetClass, LocalDate.class)) {
                return MyHelper.AsLocalDate((Object)strValue);
            }
            if (Intrinsics.areEqual((Object)targetClass, LocalTime.class)) {
                return MyHelper.AsLocalTime((Object)strValue);
            }
            if (Intrinsics.areEqual((Object)targetClass, LocalDateTime.class)) {
                return MyHelper.AsLocalDateTime((Object)strValue);
            }
        }
        if (Intrinsics.areEqual((Object)valueClass, Date.class)) {
            if (Intrinsics.areEqual((Object)targetClass, LocalDate.class)) {
                return MyHelper.AsLocalDate((Object)value);
            }
            if (Intrinsics.areEqual((Object)targetClass, LocalTime.class)) {
                return MyHelper.AsLocalTime((Object)value);
            }
            if (Intrinsics.areEqual((Object)targetClass, LocalDateTime.class)) {
                return MyHelper.AsLocalDateTime((Object)value);
            }
        }
        if (Intrinsics.areEqual((Object)targetClass, Date.class)) {
            if (Intrinsics.areEqual((Object)valueClass, LocalDate.class)) {
                return Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            }
            if (Intrinsics.areEqual((Object)valueClass, LocalTime.class)) {
                return Date.from(((LocalTime)value).atDate(MyHelper.AsLocalDate((Object)"1970-01-01")).atZone(ZoneId.systemDefault()).toInstant());
            }
            if (Intrinsics.areEqual((Object)valueClass, LocalDateTime.class)) {
                return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
            }
        }
        return null;
    }
}

