/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.mongo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.db.BaseMetaData;
import nbcp.db.mongo.IMongoDocument;
import nbcp.db.mongo.MongoBaseInsertClip;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0013B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0011\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnbcp/db/mongo/MongoBaseMetaCollection;", "T", "Lnbcp/db/mongo/IMongoDocument;", "Lnbcp/db/BaseMetaData;", "entityClass", "Ljava/lang/Class;", "entityName", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "getEntityClass", "()Ljava/lang/Class;", "doInsert", "entity", "(Lnbcp/db/mongo/IMongoDocument;)Ljava/lang/String;", "getMongoCriteria", "Lorg/springframework/data/mongodb/core/query/Criteria;", "where", "", "([Lorg/springframework/data/mongodb/core/query/Criteria;)Lorg/springframework/data/mongodb/core/query/Criteria;", "Companion", "ktmyoql"})
public abstract class MongoBaseMetaCollection<T extends IMongoDocument>
extends BaseMetaData {
    @NotNull
    private final Class<T> entityClass;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final String doInsert(@NotNull T entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        MongoBaseInsertClip batchInsert = new MongoBaseInsertClip(this.getTableName());
        batchInsert.addEntity(entity);
        batchInsert.exec();
        return entity.getId();
    }

    @NotNull
    public final Criteria getMongoCriteria(Criteria ... where) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        if (where.length == 0) {
            return new Criteria();
        }
        if (where.length == 1) {
            return where[0];
        }
        Criteria criteria = new Criteria().andOperator(Arrays.copyOf(where, where.length));
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"Criteria().andOperator(*where)");
        return criteria;
    }

    @NotNull
    public final Class<T> getEntityClass() {
        return this.entityClass;
    }

    public MongoBaseMetaCollection(@NotNull Class<T> entityClass, @NotNull String entityName) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        super(entityName);
        this.entityClass = entityClass;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Companion.getClass());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnbcp/db/mongo/MongoBaseMetaCollection$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ktmyoql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

