/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.mongo;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nbcp.db.mongo.Date2LocalDateTimeConverter;
import nbcp.db.mongo.ExistsMongoDataSourceConfigCondition;
import nbcp.utils.SpringUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@Conditional(value={ExistsMongoDataSourceConfigCondition.class})
@DependsOn(value={"springUtil"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lnbcp/db/mongo/MongoDbConfig;", "", "()V", "mongoContext", "Lorg/springframework/data/mongodb/core/mapping/MongoMappingContext;", "mongoPrimaryTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "dbFactory", "Lorg/springframework/data/mongodb/MongoDatabaseFactory;", "transactionManager", "Lorg/springframework/data/mongodb/MongoTransactionManager;", "ktmyoql"})
public class MongoDbConfig {
    @Bean
    @NotNull
    public MongoMappingContext mongoContext() {
        MongoMappingContext ret = new MongoMappingContext();
        return ret;
    }

    @Primary
    @Bean
    @NotNull
    public MongoTemplate mongoPrimaryTemplate(@NotNull MongoDatabaseFactory dbFactory) throws Exception {
        Intrinsics.checkNotNullParameter((Object)dbFactory, (String)"dbFactory");
        SpringUtil.Companion this_$iv = SpringUtil.Companion;
        boolean $i$f$getBean = false;
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(dbFactory), (MappingContext)this_$iv.getContext().getBean(MongoMappingContext.class));
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        ConversionService conversionService = converter.getConversionService();
        if (conversionService == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.springframework.core.convert.support.GenericConversionService");
        }
        ((GenericConversionService)conversionService).addConverter((GenericConverter)new Date2LocalDateTimeConverter());
        return new MongoTemplate(dbFactory, (MongoConverter)converter);
    }

    @Bean
    @NotNull
    public MongoTransactionManager transactionManager(@NotNull MongoDatabaseFactory dbFactory) {
        Intrinsics.checkNotNullParameter((Object)dbFactory, (String)"dbFactory");
        return new MongoTransactionManager(dbFactory);
    }
}

