/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.mybatis;

import javax.sql.DataSource;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.config;
import nbcp.db.mybatis.MyBatisConfig;
import nbcp.db.mybatis.MyBatisInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableTransactionManagement
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(value={"app.mybatis.package"})
@ConditionalOnBean(value={DataSourceAutoConfiguration.class})
@Lazy
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0017R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnbcp/db/mybatis/MyBatisConfig;", "Lorg/springframework/transaction/annotation/TransactionManagementConfigurer;", "()V", "dataSource", "Ljavax/sql/DataSource;", "getDataSource", "()Ljavax/sql/DataSource;", "dataSource$delegate", "Lkotlin/Lazy;", "annotationDrivenTransactionManager", "Lorg/springframework/transaction/PlatformTransactionManager;", "mapperScannerConfigurer", "Lorg/mybatis/spring/mapper/MapperScannerConfigurer;", "sqlSessionFactoryBean", "Lorg/apache/ibatis/session/SqlSessionFactory;", "sqlSessionTemplate", "Lorg/mybatis/spring/SqlSessionTemplate;", "sqlSessionFactory", "ktmyoql"})
public class MyBatisConfig
implements TransactionManagementConfigurer {
    @NotNull
    private final kotlin.Lazy dataSource$delegate = LazyKt.lazy((Function0)dataSource.2.INSTANCE);

    @NotNull
    public DataSource getDataSource() {
        kotlin.Lazy lazy = this.dataSource$delegate;
        MyBatisConfig myBatisConfig = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DataSource)lazy.getValue();
    }

    @NotNull
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return (PlatformTransactionManager)new DataSourceTransactionManager(this.getDataSource());
    }

    @Bean
    @Lazy
    @NotNull
    public MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setSqlSessionFactoryBeanName("sqlSessionFactory");
        mapperScannerConfigurer.setBasePackage(config.INSTANCE.getMybatisPackage());
        return mapperScannerConfigurer;
    }

    @Bean(name={"sqlSessionFactory"})
    @Lazy
    @Nullable
    public SqlSessionFactory sqlSessionFactoryBean() {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(this.getDataSource());
        org.apache.ibatis.session.Configuration config2 = new org.apache.ibatis.session.Configuration();
        config2.setCacheEnabled(true);
        config2.addInterceptor((Interceptor)new MyBatisInterceptor());
        bean.setConfiguration(config2);
        try {
            return bean.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Bean
    @Lazy
    @NotNull
    public SqlSessionTemplate sqlSessionTemplate(@NotNull SqlSessionFactory sqlSessionFactory) {
        Intrinsics.checkNotNullParameter((Object)sqlSessionFactory, (String)"sqlSessionFactory");
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

