/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.mysql;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.utils.SpringUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0011\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\u0006H\u0017J\u0012\u0010\b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017\u00a8\u0006\u000b"}, d2={"Lnbcp/db/mysql/MySqlConfig;", "", "()V", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "properties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "dataSourceProperties", "slave", "slaveDataSourceProperties", "Companion", "ktmyoql"})
public class MySqlConfig {
    public static final Companion Companion = new Companion(null);

    @Primary
    @Bean
    @ConfigurationProperties(value="spring.datasource")
    @NotNull
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Primary
    @Bean
    @ConfigurationProperties(prefix="spring.datasource.hikari")
    @NotNull
    public HikariDataSource dataSource(@NotNull DataSourceProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DataSource dataSource2 = properties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        if (dataSource2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.zaxxer.hikari.HikariDataSource");
        }
        HikariDataSource dataSource3 = (HikariDataSource)dataSource2;
        if (StringUtils.hasText((String)properties.getName())) {
            dataSource3.setPoolName(properties.getName());
        }
        return dataSource3;
    }

    @Bean(value={"slaveDataSourceProperties"})
    @ConfigurationProperties(value="spring.datasource-slave")
    @NotNull
    public DataSourceProperties slaveDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(value={"slave"})
    @ConfigurationProperties(prefix="spring.datasource-slave.hikari")
    @NotNull
    public HikariDataSource slave(@Autowired @Qualifier(value="slaveDataSourceProperties") @NotNull DataSourceProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DataSource dataSource2 = properties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        if (dataSource2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.zaxxer.hikari.HikariDataSource");
        }
        HikariDataSource dataSource3 = (HikariDataSource)dataSource2;
        if (StringUtils.hasText((String)properties.getName())) {
            dataSource3.setPoolName(properties.getName());
        }
        return dataSource3;
    }

    public static final boolean getHasSlave() {
        return Companion.getHasSlave();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnbcp/db/mysql/MySqlConfig$Companion;", "", "()V", "hasSlave", "", "getHasSlave$annotations", "getHasSlave", "()Z", "ktmyoql"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getHasSlave$annotations() {
        }

        public final boolean getHasSlave() {
            return SpringUtil.Companion.containsBean$default((SpringUtil.Companion)SpringUtil.Companion, (String)"slave", DataSource.class, (boolean)false, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

