/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nbcp.db.redis.AnyTypeRedisTemplate;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.redis.host"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lnbcp/db/redis/RedisConfig;", "", "()V", "redisTemplate", "Lnbcp/db/redis/AnyTypeRedisTemplate;", "connectionFactory", "Lorg/springframework/data/redis/connection/RedisConnectionFactory;", "ktmyoql"})
public class RedisConfig {
    @Bean
    @NotNull
    public AnyTypeRedisTemplate redisTemplate(@NotNull RedisConnectionFactory connectionFactory) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        AnyTypeRedisTemplate template = new AnyTypeRedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer(RedisSerializer.string());
        template.setValueSerializer(RedisSerializer.string());
        template.setHashKeySerializer(RedisSerializer.string());
        template.setHashValueSerializer(RedisSerializer.json());
        template.afterPropertiesSet();
        return template;
    }
}

