/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.redis.proxy;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyJson;
import nbcp.db.redis.BaseRedisProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J \u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0006\b\u0000\u0010\f\u0018\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\t\u001a\u00020\u0003J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\t\u001a\u00020\u0003J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0018\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u000f\u00a8\u0006\u001b"}, d2={"Lnbcp/db/redis/proxy/RedisHashProxy;", "Lnbcp/db/redis/BaseRedisProxy;", "group", "", "defaultCacheSeconds", "", "(Ljava/lang/String;I)V", "getItem", "", "key", "field", "getJson", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getMap", "", "increment", "", "value", "keys", "", "removeItems", "", "members", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "setMap", "ktmyoql"})
public final class RedisHashProxy
extends BaseRedisProxy {
    @NotNull
    public final Set<String> keys(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForHash().keys((Object)cacheKey);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForHas\u2026ng, Any>().keys(cacheKey)");
        return set2;
    }

    @NotNull
    public final Map<String, Object> getMap(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Map map2 = this.getAnyTypeCommand().opsForHash().entries((Object)cacheKey);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"anyTypeCommand.opsForHas\u2026 Any>().entries(cacheKey)");
        return map2;
    }

    public final long increment(@NotNull String key, @NotNull String field, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String cacheKey = this.getFullKey(key);
        Long l = this.getAnyTypeCommand().opsForHash().increment((Object)cacheKey, (Object)field, value);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"anyTypeCommand.opsForHas\u2026t(cacheKey, field, value)");
        return l;
    }

    public static /* synthetic */ long increment$default(RedisHashProxy redisHashProxy, String string, String string2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 1L;
        }
        return redisHashProxy.increment(string, string2, l);
    }

    @Nullable
    public final /* synthetic */ <T> T getJson(@NotNull String key) {
        Object object;
        int $i$f$getJson = 0;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, Object> map2 = this.getMap(key);
        if (map2 != null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = MyJson.ConvertJson$default(map2, Object.class, null, (int)2, null);
        } else {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public final Object getItem(@NotNull String key, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String cacheKey = this.getFullKey(key);
        return this.getAnyTypeCommand().opsForHash().get((Object)cacheKey, (Object)field);
    }

    public final void setMap(@NotNull String key, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!MapsKt.any(value)) {
            super.deleteKeys(key);
            return;
        }
        String cacheKey = this.getFullKey(key);
        this.getAnyTypeCommand().opsForHash().putAll((Object)cacheKey, value);
    }

    public final void removeItems(@NotNull String key, String ... members) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)members, (String)"members");
        String cacheKey = this.getFullKey(key);
        this.getAnyTypeCommand().opsForHash().delete((Object)cacheKey, (Object[])Arrays.copyOf(members, members.length));
    }

    @JvmOverloads
    public RedisHashProxy(@NotNull String group, int defaultCacheSeconds) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(group, defaultCacheSeconds);
    }

    public /* synthetic */ RedisHashProxy(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }

    @JvmOverloads
    public RedisHashProxy(@NotNull String group) {
        this(group, 0, 2, null);
    }
}

