/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.redis.proxy;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import nbcp.db.redis.BaseRedisProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000b\"\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003J'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000b\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0003J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0005\u00a8\u0006\u001c"}, d2={"Lnbcp/db/redis/proxy/RedisSetProxy;", "Lnbcp/db/redis/BaseRedisProxy;", "group", "", "defaultCacheSeconds", "", "(Ljava/lang/String;I)V", "add", "", "key", "value", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "getListString", "", "isMember", "", "member", "removeItems", "", "members", "(Ljava/lang/String;[Ljava/lang/String;)J", "size", "spop", "sscan", "", "pattern", "limit", "ktmyoql"})
public class RedisSetProxy
extends BaseRedisProxy {
    public final int size(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        return MyHelper.AsInt$default((Object)((int)this.getAnyTypeCommand().opsForSet().size((Object)cacheKey).longValue()), (int)0, (int)1, null);
    }

    public final boolean isMember(@NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String cacheKey = this.getFullKey(key);
        Boolean bl = this.getAnyTypeCommand().opsForSet().isMember((Object)cacheKey, (Object)member);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"anyTypeCommand.opsForSet\u2026sMember(cacheKey, member)");
        return bl;
    }

    public final long removeItems(@NotNull String key, String ... members) {
        Long ret;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)members, (String)"members");
        if (!ArraysKt.any((Object[])members)) {
            return 0L;
        }
        String cacheKey = this.getFullKey(key);
        Long l = ret = this.getAnyTypeCommand().opsForSet().remove((Object)cacheKey, (Object[])Arrays.copyOf(members, members.length));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"ret");
        return l;
    }

    public final void add(@NotNull String key, String ... value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!ArraysKt.any((Object[])value)) {
            return;
        }
        String cacheKey = this.getFullKey(key);
        this.getAnyTypeCommand().opsForSet().add((Object)cacheKey, (Object[])Arrays.copyOf(value, value.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getListString(@NotNull String key) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForSet().members((Object)cacheKey);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForSet().members(cacheKey)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String spop(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Object object = this.getAnyTypeCommand().opsForSet().pop((Object)cacheKey);
        return object != null ? object.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<String> sscan(@NotNull String key, @NotNull String pattern, int limit) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String cacheKey = this.getFullKey(key);
        Closeable closeable = (Closeable)this.getAnyTypeCommand().opsForSet().scan((Object)cacheKey, ScanOptions.scanOptions().match(this.getGroup() + pattern).count(MyHelper.AsLong$default((Object)limit, (long)0L, (int)1, null)).build());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Cursor result = (Cursor)closeable;
            boolean bl3 = false;
            boolean bl4 = false;
            Set list = new LinkedHashSet();
            while (result.hasNext()) {
                list.add(result.next().toString());
            }
            Set set2 = list;
            return set2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Set sscan$default(RedisSetProxy redisSetProxy, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sscan");
        }
        if ((n2 & 4) != 0) {
            n = 999;
        }
        return redisSetProxy.sscan(string, string2, n);
    }

    @JvmOverloads
    public RedisSetProxy(@NotNull String group, int defaultCacheSeconds) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(group, defaultCacheSeconds);
    }

    public /* synthetic */ RedisSetProxy(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }

    @JvmOverloads
    public RedisSetProxy(@NotNull String group) {
        this(group, 0, 2, null);
    }
}

