/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.redis.proxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import nbcp.db.redis.BaseRedisProxy;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032*\u0010\n\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J'\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000b\"\u00020\u0003\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003\u00a8\u0006!"}, d2={"Lnbcp/db/redis/proxy/RedisSortedSetProxy;", "Lnbcp/db/redis/BaseRedisProxy;", "group", "", "defaultCacheSeconds", "", "(Ljava/lang/String;I)V", "add", "", "key", "value", "", "Lkotlin/Pair;", "", "(Ljava/lang/String;[Lkotlin/Pair;)V", "member", "score", "getItem", "minScore", "maxScore", "getListByIndex", "", "start", "end", "getListByScore", "getScore", "isMember", "", "removeItems", "", "members", "(Ljava/lang/String;[Ljava/lang/String;)J", "size", "ktmyoql"})
public class RedisSortedSetProxy
extends BaseRedisProxy {
    public final void add(@NotNull String key, @NotNull String member, double score) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String cacheKey = this.getFullKey(key);
        this.getAnyTypeCommand().opsForZSet().add((Object)cacheKey, (Object)member, score);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull String key, Pair<String, Double> ... value) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!ArraysKt.any((Object[])value)) {
            return;
        }
        String cacheKey = this.getFullKey(key);
        Pair<String, Double>[] $this$map$iv = value;
        boolean $i$f$map = false;
        Pair<String, Double>[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var10_9 = $this$mapTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_13 = item$iv$iv = var10_9[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ZSetOperations.TypedTuple typedTuple = (ZSetOperations.TypedTuple)new DefaultTypedTuple(it.getFirst(), (Double)it.getSecond());
            collection.add(typedTuple);
        }
        Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.getAnyTypeCommand().opsForZSet().add((Object)cacheKey, set2);
    }

    public final int size(@NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String cacheKey = this.getFullKey(key);
        return MyHelper.AsInt$default((Object)this.getAnyTypeCommand().opsForZSet().size((Object)cacheKey), (int)0, (int)1, null);
    }

    public final boolean isMember(@NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String cacheKey = this.getFullKey(key);
        return this.getAnyTypeCommand().opsForZSet().score((Object)cacheKey, (Object)member) != null;
    }

    @NotNull
    public final String getItem(@NotNull String key, double minScore, double maxScore) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForZSet().rangeByScore((Object)cacheKey, minScore, maxScore, 0L, 1L);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForZSe\u2026nScore, maxScore, 0L, 1L)");
        return MyHelper.AsString$default((Object)CollectionsKt.firstOrNull((Iterable)set2), null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getListByScore(@NotNull String key, double minScore, double maxScore) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForZSet().rangeByScore((Object)cacheKey, minScore, maxScore);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForZSe\u2026eKey, minScore, maxScore)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = MyHelper.AsString$default((Object)it, null, (int)1, null);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getListByIndex(@NotNull String key, int start, int end) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForZSet().range((Object)cacheKey, (long)start, (long)end);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForZSe\u2026t.toLong(), end.toLong())");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = MyHelper.AsString$default((Object)it, null, (int)1, null);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getItem(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String cacheKey = this.getFullKey(key);
        Set set2 = this.getAnyTypeCommand().opsForZSet().range((Object)cacheKey, 0L, 0L);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"anyTypeCommand.opsForZSe\u2026).range(cacheKey, 0L, 0L)");
        return MyHelper.AsString$default((Object)CollectionsKt.firstOrNull((Iterable)set2), null, (int)1, null);
    }

    public final double getScore(@NotNull String key, @NotNull String member) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        String cacheKey = this.getFullKey(key);
        Double d = this.getAnyTypeCommand().opsForZSet().score((Object)cacheKey, (Object)member);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"anyTypeCommand.opsForZSe\u2026).score(cacheKey, member)");
        return d;
    }

    public final long removeItems(@NotNull String key, String ... members) {
        Long ret;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)members, (String)"members");
        String cacheKey = this.getFullKey(key);
        Long l = ret = this.getAnyTypeCommand().opsForZSet().remove((Object)cacheKey, (Object[])Arrays.copyOf(members, members.length));
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"ret");
        return l;
    }

    @JvmOverloads
    public RedisSortedSetProxy(@NotNull String group, int defaultCacheSeconds) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(group, defaultCacheSeconds);
    }

    public /* synthetic */ RedisSortedSetProxy(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }

    @JvmOverloads
    public RedisSortedSetProxy(@NotNull String group) {
        this(group, 0, 2, null);
    }
}

