/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.sql;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import nbcp.db.sql.DbType$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00010B3\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003R \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017j\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/\u00a8\u00061"}, d2={"Lnbcp/db/sql/DbType;", "", "remark", "", "javaType", "Ljava/lang/Class;", "sqlType", "", "javaRefType", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;ILjava/lang/Class;)V", "getJavaRefType", "()Ljava/lang/Class;", "setJavaRefType", "(Ljava/lang/Class;)V", "getJavaType", "setJavaType", "getRemark", "()Ljava/lang/String;", "setRemark", "(Ljava/lang/String;)V", "getSqlType", "()I", "setSqlType", "(I)V", "isDateOrTime", "", "isInteger", "isNumberic", "needTextWrap", "toKotlinDefaultValue", "toKotlinType", "toMySqlTypeString", "String", "Enum", "Int", "Float", "Long", "Double", "Byte", "Short", "Boolean", "Decimal", "Date", "Time", "DateTime", "Binary", "Text", "Other", "Companion", "ktmyoql"})
public final class DbType
extends Enum<DbType> {
    public static final /* enum */ DbType String;
    public static final /* enum */ DbType Enum;
    public static final /* enum */ DbType Int;
    public static final /* enum */ DbType Float;
    public static final /* enum */ DbType Long;
    public static final /* enum */ DbType Double;
    public static final /* enum */ DbType Byte;
    public static final /* enum */ DbType Short;
    public static final /* enum */ DbType Boolean;
    public static final /* enum */ DbType Decimal;
    public static final /* enum */ DbType Date;
    public static final /* enum */ DbType Time;
    public static final /* enum */ DbType DateTime;
    public static final /* enum */ DbType Binary;
    public static final /* enum */ DbType Text;
    public static final /* enum */ DbType Other;
    private static final /* synthetic */ DbType[] $VALUES;
    @NotNull
    private String remark;
    @NotNull
    private Class<?> javaType;
    @Nullable
    private Class<?> javaRefType;
    private int sqlType;
    public static final Companion Companion;

    static {
        DbType[] dbTypeArray = new DbType[16];
        DbType[] dbTypeArray2 = dbTypeArray;
        dbTypeArray[0] = String = new DbType("String", 0, "\u5b57\u7b26\u4e32", String.class, 12, null, 8, null);
        dbTypeArray[1] = Enum = new DbType("Enum", 1, "\u679a\u4e3e", String.class, 12, null, 8, null);
        dbTypeArray[2] = Int = new DbType("\u6574\u6570", Integer.TYPE, 4, Integer.class);
        dbTypeArray[3] = Float = new DbType("\u6d6e\u70b9\u6570", java.lang.Float.TYPE, 6, Float.class);
        dbTypeArray[4] = Long = new DbType("\u957f\u6574\u6570", java.lang.Long.TYPE, -5, Long.class);
        dbTypeArray[5] = Double = new DbType("\u53cc\u7cbe\u5ea6", java.lang.Double.TYPE, 8, Double.class);
        dbTypeArray[6] = Byte = new DbType("\u5b57\u8282", java.lang.Byte.TYPE, -6, Byte.class);
        dbTypeArray[7] = Short = new DbType("\u77ed\u6574\u6570", java.lang.Short.TYPE, 5, Short.class);
        dbTypeArray[8] = Boolean = new DbType("\u5e03\u5c14", java.lang.Boolean.TYPE, -7, Boolean.class);
        dbTypeArray[9] = Decimal = new DbType("Decimal", 9, "\u5927\u6570\u5b57", BigDecimal.class, 3, null, 8, null);
        dbTypeArray[10] = Date = new DbType("Date", 10, "\u65e5\u671f", LocalDate.class, 91, null, 8, null);
        dbTypeArray[11] = Time = new DbType("Time", 11, "\u65f6\u95f4", LocalTime.class, 92, null, 8, null);
        dbTypeArray[12] = DateTime = new DbType("DateTime", 12, "\u65e5\u671f\u65f6\u95f4", LocalDateTime.class, 93, null, 8, null);
        dbTypeArray[13] = Binary = new DbType("Binary", 13, "\u4e8c\u8fdb\u5236\u6570\u636e", byte[].class, -3, null, 8, null);
        dbTypeArray[14] = Text = new DbType("Text", 14, "\u5927\u6587\u672c", String.class, -1, null, 8, null);
        dbTypeArray[15] = Other = new DbType("Other", 15, "\u8868\u8fbe\u5f0f\u7c7b\u578b", Object.class, 1111, null, 8, null);
        $VALUES = dbTypeArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final String getRemark() {
        return this.remark;
    }

    public final void setRemark(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.remark = string;
    }

    @NotNull
    public final Class<?> getJavaType() {
        return this.javaType;
    }

    public final void setJavaType(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
        this.javaType = clazz;
    }

    @Nullable
    public final Class<?> getJavaRefType() {
        return this.javaRefType;
    }

    public final void setJavaRefType(@Nullable Class<?> clazz) {
        this.javaRefType = clazz;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final void setSqlType(int n) {
        this.sqlType = n;
    }

    public final boolean needTextWrap() {
        return this == String || this == Text || this == Enum || this.isDateOrTime();
    }

    public final boolean isNumberic() {
        return this.isInteger() || this == Float || this == Double;
    }

    public final boolean isDateOrTime() {
        return this == Date || this == Time || this == DateTime;
    }

    public final boolean isInteger() {
        return this == Int || this == Long || this == Short || this == Byte || this == Boolean;
    }

    @NotNull
    public final String toMySqlTypeString() {
        String string;
        switch (DbType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                string = "varchar(800)";
                break;
            }
            case 2: {
                string = "text(65535)";
                break;
            }
            case 3: {
                string = "varchar(800)";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case 5: {
                string = "float";
                break;
            }
            case 6: {
                string = "bigint";
                break;
            }
            case 7: {
                string = "double";
                break;
            }
            case 8: {
                string = "tinyint";
                break;
            }
            case 9: {
                string = "tinyint";
                break;
            }
            case 10: {
                string = "bit";
                break;
            }
            case 11: {
                string = "decimal";
                break;
            }
            case 12: {
                string = "date";
                break;
            }
            case 13: {
                string = "time";
                break;
            }
            case 14: {
                string = "datetime";
                break;
            }
            case 15: {
                string = "binary";
                break;
            }
            case 16: {
                string = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String toKotlinType() {
        if (this == Boolean) {
            return "Boolean?";
        }
        if (this == Date) {
            return "LocalDate?";
        }
        if (this == Time) {
            return "LocalTime?";
        }
        if (this == DateTime) {
            return "LocalDateTime?";
        }
        if (this == Other) {
            return "Any?";
        }
        if (this == Text) {
            return "String";
        }
        return MyHelper.getKotlinTypeName(this.javaType);
    }

    @NotNull
    public final String toKotlinDefaultValue() {
        String string;
        switch (DbType$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                string = "\"\"";
                break;
            }
            case 2: {
                string = "\"\"";
                break;
            }
            case 3: {
                string = "\"\"";
                break;
            }
            case 4: {
                string = "0";
                break;
            }
            case 5: {
                string = "0F";
                break;
            }
            case 6: {
                string = "0L";
                break;
            }
            case 7: {
                string = "0.0";
                break;
            }
            case 8: {
                string = "0";
                break;
            }
            case 9: {
                string = "0";
                break;
            }
            case 10: {
                string = "null";
                break;
            }
            case 11: {
                string = "BigDecimal.ZERO";
                break;
            }
            case 12: {
                string = "null";
                break;
            }
            case 13: {
                string = "null";
                break;
            }
            case 14: {
                string = "null";
                break;
            }
            case 15: {
                string = "byteArrayOf()";
                break;
            }
            case 16: {
                string = "null";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private DbType(String remark, Class<?> javaType, int sqlType, Class<?> javaRefType) {
        this.remark = "";
        this.remark = remark;
        this.javaType = javaType;
        this.sqlType = sqlType;
        this.javaRefType = javaRefType;
    }

    /* synthetic */ DbType(String string, int n, String string2, Class clazz, int n2, Class clazz2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            clazz2 = null;
        }
        this(string2, clazz, n2, clazz2);
    }

    public static DbType[] values() {
        return (DbType[])$VALUES.clone();
    }

    public static DbType valueOf(String string) {
        return java.lang.Enum.valueOf(DbType.class, string);
    }

    @JvmStatic
    @NotNull
    public static final <T> DbType of(@NotNull Class<T> clazz) {
        return Companion.of(clazz);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007\u00a8\u0006\b"}, d2={"Lnbcp/db/sql/DbType$Companion;", "", "()V", "of", "Lnbcp/db/sql/DbType;", "T", "clazz", "Ljava/lang/Class;", "ktmyoql"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> DbType of(@NotNull Class<T> clazz) {
            DbType dbType;
            block5: {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                if (clazz.isEnum()) {
                    return Enum;
                }
                DbType[] $this$firstOrNull$iv = DbType.values();
                boolean $i$f$firstOrNull = false;
                DbType[] dbTypeArray = $this$firstOrNull$iv;
                int n = dbTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    DbType element$iv;
                    DbType it = element$iv = dbTypeArray[i];
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getJavaType(), clazz) || it.getJavaRefType() != null && Intrinsics.areEqual(it.getJavaRefType(), clazz))) continue;
                    dbType = element$iv;
                    break block5;
                }
                dbType = null;
            }
            DbType dbType2 = dbType;
            boolean bl = false;
            boolean bl2 = false;
            DbType $this$apply = dbType2;
            boolean bl3 = false;
            if ($this$apply != null) {
                return $this$apply;
            }
            if (Intrinsics.areEqual(clazz, Character.class) || Intrinsics.areEqual(clazz, Character.class)) {
                return String;
            }
            if (Intrinsics.areEqual(clazz, ((Object)((Object)Date)).getClass())) {
                return DateTime;
            }
            return Other;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

