/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.sql;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.comm.MyHelper;
import nbcp.db.sql.DbType;
import nbcp.db.sql.SingleSqlData;
import nbcp.db.sql.SqlColumnNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013R&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Lnbcp/db/sql/SqlColumnName;", "Lnbcp/db/sql/SingleSqlData;", "dbType", "Lnbcp/db/sql/DbType;", "tableName", "", "name", "(Lnbcp/db/sql/DbType;Ljava/lang/String;Ljava/lang/String;)V", "columnAliaValue", "getDbType", "()Lnbcp/db/sql/DbType;", "fullName", "getFullName", "()Ljava/lang/String;", "jsonKeyName", "getJsonKeyName", "value", "getName", "setName", "(Ljava/lang/String;)V", "getTableName", "setTableName", "alias", "equals", "", "other", "", "getAliasName", "toArray", "Lnbcp/db/sql/SqlColumnNames;", "toString", "Companion", "ktmyoql"})
public class SqlColumnName
extends SingleSqlData {
    @NotNull
    private String tableName;
    @NotNull
    private String name;
    private String columnAliaValue;
    @NotNull
    private final DbType dbType;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    public final void setTableName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.tableName = value;
        super.setExpression(this.getFullName());
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = value;
        super.setExpression(this.getFullName());
    }

    @NotNull
    public String getFullName() {
        if (MyHelper.getHasValue((String)this.getTableName())) {
            return '`' + this.getTableName() + "`.`" + this.getName() + '`';
        }
        return String.valueOf(this.getName());
    }

    @NotNull
    public String getJsonKeyName() {
        if (MyHelper.getHasValue((String)this.columnAliaValue)) {
            return this.columnAliaValue;
        }
        if (MyHelper.getHasValue((String)this.getTableName())) {
            return this.getTableName() + '_' + this.getName();
        }
        return String.valueOf(this.getName());
    }

    @NotNull
    public final SqlColumnName alias(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (Intrinsics.areEqual((Object)alias, (Object)this.getName())) {
            this.columnAliaValue = "";
            return this;
        }
        SqlColumnName ret = new SqlColumnName(this.dbType, this.getTableName(), this.getName());
        ret.columnAliaValue = alias;
        return ret;
    }

    @NotNull
    public final String getAliasName() {
        return MyHelper.AsString((Object)this.columnAliaValue, (String)this.getName());
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public boolean equals(@Nullable Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof SqlColumnName) {
            return this.dbType == ((SqlColumnName)other).dbType && Intrinsics.areEqual((Object)this.getTableName(), (Object)((SqlColumnName)other).getTableName()) && Intrinsics.areEqual((Object)this.getName(), (Object)((SqlColumnName)other).getName()) && Intrinsics.areEqual((Object)this.columnAliaValue, (Object)((SqlColumnName)other).columnAliaValue);
        }
        return false;
    }

    @NotNull
    public final SqlColumnNames toArray() {
        return new SqlColumnNames(this);
    }

    @NotNull
    public final DbType getDbType() {
        return this.dbType;
    }

    public SqlColumnName(@NotNull DbType dbType, @NotNull String tableName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbType), (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null, null, 3, null);
        this.dbType = dbType;
        this.tableName = tableName;
        this.name = name;
        super.setExpression(this.getFullName());
        this.columnAliaValue = "";
    }

    @JvmStatic
    @NotNull
    public static final SqlColumnName of(@NotNull String name) {
        return Companion.of(name);
    }

    @JvmStatic
    @NotNull
    public static final SqlColumnName of(@NotNull DbType dbType, @NotNull String name) {
        return Companion.of(dbType, name);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lnbcp/db/sql/SqlColumnName$Companion;", "", "()V", "of", "Lnbcp/db/sql/SqlColumnName;", "name", "", "dbType", "Lnbcp/db/sql/DbType;", "ktmyoql"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SqlColumnName of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SqlColumnName(DbType.Other, "", name);
        }

        @JvmStatic
        @NotNull
        public final SqlColumnName of(@NotNull DbType dbType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)((Object)dbType), (String)"dbType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SqlColumnName(dbType, "", name);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

