/*
 * Decompiled with CFR 0.152.
 */
package nbcp.db.sql.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nbcp.db.BaseMetaData;
import nbcp.db.DbEntityFieldRef;
import nbcp.db.DbEntityFieldRefData;
import nbcp.db.DbEntityFieldRefs;
import nbcp.db.EventResult;
import nbcp.db.RemoveToSysDustbin;
import nbcp.db.db;
import nbcp.db.sql.IDataGroup;
import nbcp.db.sql.ISqlDbEntity;
import nbcp.db.sql.SqlBaseMetaTable;
import nbcp.db.sql.SqlBaseQueryClip;
import nbcp.db.sql.SqlDeleteClip;
import nbcp.db.sql.SqlInsertClip;
import nbcp.db.sql.SqlUpdateClip;
import nbcp.db.sql.event.ISqlDataSource;
import nbcp.db.sql.event.ISqlEntityDelete;
import nbcp.db.sql.event.ISqlEntityInsert;
import nbcp.db.sql.event.ISqlEntitySelect;
import nbcp.db.sql.event.ISqlEntityUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0017\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0012J\u0018\u0010\b\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0012J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J1\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00110\u00102\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00110\u00102\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00110\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J1\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00110\u00102\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0016\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\fH\u0016\u00a8\u0006+"}, d2={"Lnbcp/db/sql/event/SqlEntityEvent;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "addDustbin", "", "entityClass", "Ljava/lang/Class;", "Lnbcp/db/sql/ISqlDbEntity;", "addRef", "getDataSource", "Ljavax/sql/DataSource;", "tableName", "", "isRead", "", "onDeleting", "", "Lkotlin/Pair;", "Lnbcp/db/sql/event/ISqlEntityDelete;", "Lnbcp/db/EventResult;", "delete", "Lnbcp/db/sql/SqlDeleteClip;", "(Lnbcp/db/sql/SqlDeleteClip;)[Lkotlin/Pair;", "onInserting", "Lnbcp/db/sql/event/ISqlEntityInsert;", "insert", "Lnbcp/db/sql/SqlInsertClip;", "(Lnbcp/db/sql/SqlInsertClip;)[Lkotlin/Pair;", "onSelecting", "Lnbcp/db/sql/event/ISqlEntitySelect;", "select", "Lnbcp/db/sql/SqlBaseQueryClip;", "(Lnbcp/db/sql/SqlBaseQueryClip;)[Lkotlin/Pair;", "onUpdating", "Lnbcp/db/sql/event/ISqlEntityUpdate;", "update", "Lnbcp/db/sql/SqlUpdateClip;", "(Lnbcp/db/sql/SqlUpdateClip;)[Lkotlin/Pair;", "postProcessAfterInitialization", "", "bean", "beanName", "Companion", "ktmyoql"})
public class SqlEntityEvent
implements BeanPostProcessor {
    @NotNull
    private static final Set<Class<?>> dustbinEntitys;
    @NotNull
    private static final List<DbEntityFieldRefData> refsMap;
    @NotNull
    private static final List<ISqlEntitySelect> selectEvent;
    @NotNull
    private static final List<ISqlEntityInsert> insertEvent;
    @NotNull
    private static final List<ISqlEntityUpdate> updateEvent;
    @NotNull
    private static final List<ISqlEntityDelete> deleteEvent;
    @NotNull
    private static final List<ISqlDataSource> dataSources;
    public static final Companion Companion;

    @Nullable
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (bean instanceof IDataGroup) {
            db.INSTANCE.getSql().getGroups().add((IDataGroup)bean);
            Iterable $this$forEach$iv = ((IDataGroup)bean).getEntities();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BaseMetaData moer = (BaseMetaData)element$iv;
                boolean bl = false;
                if (!(moer instanceof SqlBaseMetaTable)) continue;
                Class entityClass = ((SqlBaseMetaTable)moer).getTableClass();
                this.addDustbin(entityClass);
                this.addRef(entityClass);
            }
        }
        if (bean instanceof ISqlEntitySelect) {
            selectEvent.add((ISqlEntitySelect)bean);
        }
        if (bean instanceof ISqlEntityInsert) {
            insertEvent.add((ISqlEntityInsert)bean);
        }
        if (bean instanceof ISqlEntityUpdate) {
            updateEvent.add((ISqlEntityUpdate)bean);
        }
        if (bean instanceof ISqlEntityDelete) {
            deleteEvent.add((ISqlEntityDelete)bean);
        }
        if (bean instanceof ISqlDataSource) {
            dataSources.add((ISqlDataSource)bean);
        }
        return super.postProcessAfterInitialization(bean, beanName);
    }

    @Nullable
    public DataSource getDataSource(@NotNull String tableName, boolean isRead) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DataSource ret = null;
        Iterable $this$ForEachExt$iv = dataSources;
        boolean $i$f$ForEachExt = false;
        if (CollectionsKt.any((Iterable)$this$ForEachExt$iv)) {
            int index$iv = -1;
            while (++index$iv < CollectionsKt.count((Iterable)$this$ForEachExt$iv)) {
                Object element$iv = CollectionsKt.elementAt((Iterable)$this$ForEachExt$iv, (int)index$iv);
                int n = index$iv;
                ISqlDataSource iSqlDataSource = (ISqlDataSource)element$iv;
                boolean bl = false;
                DataSource ret2 = iSqlDataSource.run(tableName, isRead);
                if (ret2 != null) continue;
                break;
            }
        }
        return ret;
    }

    private void addRef(Class<? extends ISqlDbEntity> entityClass) {
        DbEntityFieldRef ref;
        DbEntityFieldRefs refs = entityClass.getAnnotation(DbEntityFieldRefs.class);
        if (refs != null && ArraysKt.any((Object[])refs.values())) {
            DbEntityFieldRef[] $this$forEach$iv = refs.values();
            boolean $i$f$forEach = false;
            DbEntityFieldRef[] dbEntityFieldRefArray = $this$forEach$iv;
            int n = dbEntityFieldRefArray.length;
            for (int i = 0; i < n; ++i) {
                DbEntityFieldRef element$iv;
                DbEntityFieldRef it = element$iv = dbEntityFieldRefArray[i];
                boolean bl = false;
                refsMap.add(new DbEntityFieldRefData(entityClass, it));
            }
        }
        if ((ref = entityClass.getAnnotation(DbEntityFieldRef.class)) != null) {
            refsMap.add(new DbEntityFieldRefData(entityClass, ref));
        }
    }

    private void addDustbin(Class<? extends ISqlDbEntity> entityClass) {
        RemoveToSysDustbin dustbin = entityClass.getAnnotation(RemoveToSysDustbin.class);
        if (dustbin != null) {
            dustbinEntitys.add(entityClass);
        }
    }

    @NotNull
    public Pair<ISqlEntitySelect, EventResult>[] onSelecting(@NotNull SqlBaseQueryClip select) {
        Intrinsics.checkNotNullParameter((Object)select, (String)"select");
        boolean bl = false;
        List list = new ArrayList();
        Iterable $this$ForEachExt$iv = selectEvent;
        boolean $i$f$ForEachExt = false;
        if (CollectionsKt.any((Iterable)$this$ForEachExt$iv)) {
            int index$iv = -1;
            while (++index$iv < CollectionsKt.count((Iterable)$this$ForEachExt$iv)) {
                boolean bl2;
                Object element$iv = CollectionsKt.elementAt((Iterable)$this$ForEachExt$iv, (int)index$iv);
                int n = index$iv;
                ISqlEntitySelect it = (ISqlEntitySelect)element$iv;
                boolean bl3 = false;
                EventResult ret = it.beforeSelect(select);
                if (ret != null && !ret.getResult()) {
                    bl2 = false;
                } else {
                    list.add(TuplesKt.to((Object)it, (Object)ret));
                    bl2 = true;
                }
                if (bl2) continue;
                break;
            }
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return pairArray;
    }

    @NotNull
    public Pair<ISqlEntityInsert, EventResult>[] onInserting(@NotNull SqlInsertClip<?, ?> insert) {
        Intrinsics.checkNotNullParameter(insert, (String)"insert");
        boolean bl = false;
        List list = new ArrayList();
        Iterable $this$ForEachExt$iv = insertEvent;
        boolean $i$f$ForEachExt = false;
        if (CollectionsKt.any((Iterable)$this$ForEachExt$iv)) {
            int index$iv = -1;
            while (++index$iv < CollectionsKt.count((Iterable)$this$ForEachExt$iv)) {
                boolean bl2;
                Object element$iv = CollectionsKt.elementAt((Iterable)$this$ForEachExt$iv, (int)index$iv);
                int n = index$iv;
                ISqlEntityInsert it = (ISqlEntityInsert)element$iv;
                boolean bl3 = false;
                EventResult ret = it.beforeInsert(insert);
                if (ret != null && !ret.getResult()) {
                    bl2 = false;
                } else {
                    list.add(TuplesKt.to((Object)it, (Object)ret));
                    bl2 = true;
                }
                if (bl2) continue;
                break;
            }
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return pairArray;
    }

    @NotNull
    public Pair<ISqlEntityUpdate, EventResult>[] onUpdating(@NotNull SqlUpdateClip<?, ?> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        boolean bl = false;
        List list = new ArrayList();
        Iterable $this$ForEachExt$iv = updateEvent;
        boolean $i$f$ForEachExt = false;
        if (CollectionsKt.any((Iterable)$this$ForEachExt$iv)) {
            int index$iv = -1;
            while (++index$iv < CollectionsKt.count((Iterable)$this$ForEachExt$iv)) {
                boolean bl2;
                Object element$iv = CollectionsKt.elementAt((Iterable)$this$ForEachExt$iv, (int)index$iv);
                int n = index$iv;
                ISqlEntityUpdate it = (ISqlEntityUpdate)element$iv;
                boolean bl3 = false;
                EventResult ret = it.beforeUpdate(update);
                if (ret != null && !ret.getResult()) {
                    bl2 = false;
                } else {
                    list.add(TuplesKt.to((Object)it, (Object)ret));
                    bl2 = true;
                }
                if (bl2) continue;
                break;
            }
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return pairArray;
    }

    @NotNull
    public Pair<ISqlEntityDelete, EventResult>[] onDeleting(@NotNull SqlDeleteClip<?, ?> delete) {
        Intrinsics.checkNotNullParameter(delete, (String)"delete");
        boolean bl = false;
        List list = new ArrayList();
        Iterable $this$ForEachExt$iv = deleteEvent;
        boolean $i$f$ForEachExt = false;
        if (CollectionsKt.any((Iterable)$this$ForEachExt$iv)) {
            int index$iv = -1;
            while (++index$iv < CollectionsKt.count((Iterable)$this$ForEachExt$iv)) {
                boolean bl2;
                Object element$iv = CollectionsKt.elementAt((Iterable)$this$ForEachExt$iv, (int)index$iv);
                int n = index$iv;
                ISqlEntityDelete it = (ISqlEntityDelete)element$iv;
                boolean bl3 = false;
                EventResult ret = it.beforeDelete(delete);
                if (ret != null && !ret.getResult()) {
                    bl2 = false;
                } else {
                    list.add(TuplesKt.to((Object)it, (Object)ret));
                    bl2 = true;
                }
                if (bl2) continue;
                break;
            }
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return pairArray;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        dustbinEntitys = new LinkedHashSet();
        bl = false;
        refsMap = new ArrayList();
        bl = false;
        selectEvent = new ArrayList();
        bl = false;
        insertEvent = new ArrayList();
        bl = false;
        updateEvent = new ArrayList();
        bl = false;
        deleteEvent = new ArrayList();
        bl = false;
        dataSources = new ArrayList();
    }

    @NotNull
    public static final Set<Class<?>> getDustbinEntitys() {
        Companion companion = Companion;
        return dustbinEntitys;
    }

    @NotNull
    public static final List<DbEntityFieldRefData> getRefsMap() {
        Companion companion = Companion;
        return refsMap;
    }

    @NotNull
    public static final List<ISqlEntitySelect> getSelectEvent() {
        Companion companion = Companion;
        return selectEvent;
    }

    @NotNull
    public static final List<ISqlEntityInsert> getInsertEvent() {
        Companion companion = Companion;
        return insertEvent;
    }

    @NotNull
    public static final List<ISqlEntityUpdate> getUpdateEvent() {
        Companion companion = Companion;
        return updateEvent;
    }

    @NotNull
    public static final List<ISqlEntityDelete> getDeleteEvent() {
        Companion companion = Companion;
        return deleteEvent;
    }

    @NotNull
    public static final List<ISqlDataSource> getDataSources() {
        Companion companion = Companion;
        return dataSources;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\bR&\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\bR\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\bR\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\bR\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\b\u00a8\u0006#"}, d2={"Lnbcp/db/sql/event/SqlEntityEvent$Companion;", "", "()V", "dataSources", "", "Lnbcp/db/sql/event/ISqlDataSource;", "getDataSources$annotations", "getDataSources", "()Ljava/util/List;", "deleteEvent", "Lnbcp/db/sql/event/ISqlEntityDelete;", "getDeleteEvent$annotations", "getDeleteEvent", "dustbinEntitys", "", "Ljava/lang/Class;", "getDustbinEntitys$annotations", "getDustbinEntitys", "()Ljava/util/Set;", "insertEvent", "Lnbcp/db/sql/event/ISqlEntityInsert;", "getInsertEvent$annotations", "getInsertEvent", "refsMap", "Lnbcp/db/DbEntityFieldRefData;", "getRefsMap$annotations", "getRefsMap", "selectEvent", "Lnbcp/db/sql/event/ISqlEntitySelect;", "getSelectEvent$annotations", "getSelectEvent", "updateEvent", "Lnbcp/db/sql/event/ISqlEntityUpdate;", "getUpdateEvent$annotations", "getUpdateEvent", "ktmyoql"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDustbinEntitys$annotations() {
        }

        @NotNull
        public final Set<Class<?>> getDustbinEntitys() {
            return dustbinEntitys;
        }

        @JvmStatic
        public static /* synthetic */ void getRefsMap$annotations() {
        }

        @NotNull
        public final List<DbEntityFieldRefData> getRefsMap() {
            return refsMap;
        }

        @JvmStatic
        public static /* synthetic */ void getSelectEvent$annotations() {
        }

        @NotNull
        public final List<ISqlEntitySelect> getSelectEvent() {
            return selectEvent;
        }

        @JvmStatic
        public static /* synthetic */ void getInsertEvent$annotations() {
        }

        @NotNull
        public final List<ISqlEntityInsert> getInsertEvent() {
            return insertEvent;
        }

        @JvmStatic
        public static /* synthetic */ void getUpdateEvent$annotations() {
        }

        @NotNull
        public final List<ISqlEntityUpdate> getUpdateEvent() {
            return updateEvent;
        }

        @JvmStatic
        public static /* synthetic */ void getDeleteEvent$annotations() {
        }

        @NotNull
        public final List<ISqlEntityDelete> getDeleteEvent() {
            return deleteEvent;
        }

        @JvmStatic
        public static /* synthetic */ void getDataSources$annotations() {
        }

        @NotNull
        public final List<ISqlDataSource> getDataSources() {
            return dataSources;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

