/*
 * Decompiled with CFR 0.152.
 */
package cn.dgchong.maven.yapi.builder;

import cn.dgchong.maven.yapi.config.YapiConfig;
import cn.dgchong.maven.yapi.model.YapiCatItem;
import cn.dgchong.maven.yapi.model.YapiCatItemParam;
import cn.dgchong.maven.yapi.model.YapiCatModel;
import cn.dgchong.maven.yapi.model.req.ApiDocModel;
import cn.dgchong.maven.yapi.model.req.PropertiesItem;
import cn.dgchong.maven.yapi.model.req.ReqHeadersItem;
import cn.dgchong.maven.yapi.model.req.ReqQueryItem;
import cn.dgchong.maven.yapi.model.rsp.YapiCatMenuAddResult;
import cn.dgchong.maven.yapi.model.rsp.YapiCatMenuModel;
import cn.dgchong.maven.yapi.model.rsp.YapiCatMenuResult;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.power.common.util.FileUtil;
import com.power.doc.builder.ApiDataBuilder;
import com.power.doc.model.ApiAllData;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class YapiBuilder {
    private static Log log = new SystemStreamLog();

    public static void buildApiDoc(YapiConfig yapiConfig) throws FileNotFoundException {
        ApiAllData docList = YapiBuilder.buildSmartDocApiDoc(yapiConfig);
        List<YapiCatModel> yapiCatModelList = YapiBuilder.buildYapiCatModel(yapiConfig, docList);
        YapiBuilder.syncToYapi(yapiConfig, yapiCatModelList);
    }

    public static List<YapiCatMenuModel> getCatMenus(YapiConfig yapiConfig) {
        String path = yapiConfig.getYapiServerUrl() + "/api/interface/getCatMenu" + "?token=" + yapiConfig.getYapiProjectToken();
        String catMenuResult = HttpUtil.get((String)path);
        if (StringUtils.isEmpty((CharSequence)catMenuResult)) {
            return null;
        }
        YapiCatMenuResult yapiCatMenuResult = (YapiCatMenuResult)JSON.parseObject((String)catMenuResult, YapiCatMenuResult.class);
        return yapiCatMenuResult.getData();
    }

    public static YapiCatMenuModel addCat(YapiConfig yapiConfig, Integer projectId, String name, String desc) {
        HashMap<String, Object> bodyParamMap = new HashMap<String, Object>();
        bodyParamMap.put("token", yapiConfig.getYapiProjectToken());
        bodyParamMap.put("project_id", projectId);
        bodyParamMap.put("name", name);
        bodyParamMap.put("desc", desc);
        String addCatResult = HttpUtil.post((String)(yapiConfig.getYapiServerUrl() + "/api/interface/add_cat"), bodyParamMap);
        YapiCatMenuAddResult yapiCatMenuAddResult = (YapiCatMenuAddResult)JSON.parseObject((String)addCatResult, YapiCatMenuAddResult.class);
        return yapiCatMenuAddResult.getData();
    }

    private static List<YapiCatModel> buildYapiCatModel(YapiConfig yapiConfig, ApiAllData docList) {
        ArrayList<YapiCatModel> yapiCatModelList = new ArrayList<YapiCatModel>();
        for (ApiDoc apiDoc : docList.getApiDocList()) {
            String catName = apiDoc.getDesc();
            if (StringUtils.isEmpty((CharSequence)catName)) {
                catName = apiDoc.getName();
            }
            YapiCatModel yapiCatModel = YapiCatModel.builder().catName(catName).catItems(new ArrayList<YapiCatItem>()).build();
            for (ApiMethodDoc apiMethodDoc : apiDoc.getList()) {
                List<YapiCatItemParam> yapiHeaders = YapiBuilder.adapterSmartDocHeadersParam(apiMethodDoc.getRequestHeaders());
                List<YapiCatItemParam> yapiQuerys = YapiBuilder.adapterSmartDocParam(apiMethodDoc.getQueryParams().stream().filter(apiParam -> apiParam.isQueryParam()).collect(Collectors.toList()));
                List<YapiCatItemParam> yapiBodys = YapiBuilder.adapterSmartDocParam(apiMethodDoc.getQueryParams().stream().filter(apiParam -> !apiParam.isQueryParam()).collect(Collectors.toList()));
                List<YapiCatItemParam> yapiResponse = YapiBuilder.adapterSmartDocParam(apiMethodDoc.getResponseParams());
                YapiCatItem yapiCatItem = YapiCatItem.builder().requestType(apiMethodDoc.getType()).interfaceTitle(apiMethodDoc.getDesc()).interfacePath(apiMethodDoc.getUrl()).headers(yapiHeaders).querys(yapiQuerys).bodys(yapiBodys).response(yapiResponse).build();
                yapiCatModel.getCatItems().add(yapiCatItem);
            }
            yapiCatModelList.add(yapiCatModel);
        }
        List<YapiCatMenuModel> yapiCatMenuModels = YapiBuilder.getCatMenus(yapiConfig);
        Map catNameMap = yapiCatMenuModels.stream().collect(Collectors.toMap(YapiCatMenuModel::getName, Function.identity()));
        for (YapiCatModel yapiCatModel : yapiCatModelList) {
            String catName = yapiCatModel.getCatName();
            if (catNameMap.containsKey(catName)) {
                yapiCatModel.setCatid(((YapiCatMenuModel)catNameMap.get(catName)).get_id());
                continue;
            }
            YapiCatMenuModel yapiCatMenuModel = YapiBuilder.addCat(yapiConfig, yapiCatMenuModels.get(0).getProject_id(), catName, "");
            yapiCatModel.setCatid(yapiCatMenuModel.get_id());
        }
        return yapiCatModelList;
    }

    public static ApiAllData buildSmartDocApiDoc(YapiConfig yapiConfig) throws FileNotFoundException {
        ApiConfig apiConfig = new ApiConfig();
        if (StringUtils.isNotEmpty((CharSequence)yapiConfig.getPackageFilters())) {
            apiConfig.setPackageFilters(yapiConfig.getPackageFilters());
        }
        if (Objects.nonNull(yapiConfig.getConfigFile())) {
            String data = FileUtil.getFileContent((InputStream)new FileInputStream(yapiConfig.getConfigFile()));
            ApiConfig apiConfigJson = (ApiConfig)JSON.parseObject((String)data, ApiConfig.class);
            apiConfig.setRequestHeaders(apiConfigJson.getRequestHeaders());
        }
        return ApiDataBuilder.getApiDataTree((ApiConfig)apiConfig);
    }

    public static void syncToYapi(YapiConfig yapiConfig, List<YapiCatModel> yapiCatModelList) {
        long start = System.currentTimeMillis();
        int totalInterface = 0;
        int successCount = 0;
        for (YapiCatModel yapiCatModel : yapiCatModelList) {
            List<YapiCatItem> catItems = yapiCatModel.getCatItems();
            for (YapiCatItem yapiCatItem : catItems) {
                List<ReqQueryItem> req_query_body;
                ArrayList<ReqHeadersItem> req_headers = null;
                List<YapiCatItemParam> headers = yapiCatItem.getHeaders();
                if (Objects.nonNull(headers) && 0 < headers.size()) {
                    req_headers = new ArrayList<ReqHeadersItem>();
                    for (YapiCatItemParam itemParam : headers) {
                        req_headers.add(new ReqHeadersItem(itemParam.getName(), itemParam.getValue(), itemParam.getDesc(), YapiBuilder.adapterRequired(itemParam.getRequired()), ""));
                    }
                }
                List<ReqQueryItem> req_query = YapiBuilder.buildReqQuery(yapiCatItem.getQuerys());
                if ("GET".equals(yapiCatItem.getRequestType()) && Objects.nonNull(req_query_body = YapiBuilder.buildReqQuery(yapiCatItem.getBodys()))) {
                    if (Objects.isNull(req_query)) {
                        req_query = new ArrayList<ReqQueryItem>();
                    }
                    req_query.addAll(req_query_body);
                }
                String body_other_str = YapiBuilder.buildReqResBodyJson(yapiCatItem.getBodys());
                String res_body_str = YapiBuilder.buildReqResBodyJson(yapiCatItem.getResponse());
                ApiDocModel apiDocModel = ApiDocModel.builder().token(yapiConfig.getYapiProjectToken()).catid(yapiCatModel.getCatid()).method(yapiCatItem.getRequestType()).title(yapiCatItem.getInterfaceTitle()).path(yapiCatItem.getInterfacePath()).req_headers(req_headers).req_query(req_query).req_body_type("json").req_body_is_json_schema(true).req_body_other(body_other_str).res_body_type("json").res_body_is_json_schema(true).res_body(res_body_str).build();
                String body = JSON.toJSONString((Object)apiDocModel);
                String result = ((HttpRequest)HttpRequest.post((String)(yapiConfig.getYapiServerUrl() + "/api/interface/save")).header("Content-Type", "application/json")).body(body).execute().body();
                if (0 == (Integer)((JSONObject)JSON.parseObject((String)result, JSONObject.class)).get((Object)"errcode")) {
                    ++successCount;
                    continue;
                }
                log.error((CharSequence)String.format("sync error,body:%s,result:%s", body, result));
            }
            totalInterface += catItems.size();
        }
        StringBuilder sb = new StringBuilder("sync api doc,").append("cost:").append(System.currentTimeMillis() - start).append("ms,").append("cat:").append(yapiCatModelList.size()).append(",").append("api:").append(totalInterface).append(",").append("success:").append(successCount).append(",").append("fail:").append(totalInterface - successCount).append(".");
        log.info((CharSequence)sb.toString());
    }

    private static List<ReqQueryItem> buildReqQuery(List<YapiCatItemParam> querys) {
        if (Objects.isNull(querys) || 0 == querys.size()) {
            return null;
        }
        ArrayList<ReqQueryItem> req_query = new ArrayList<ReqQueryItem>();
        for (YapiCatItemParam itemParam : querys) {
            req_query.add(new ReqQueryItem(itemParam.getName(), itemParam.getDesc(), YapiBuilder.adapterRequired(itemParam.getRequired()), null));
        }
        return req_query;
    }

    private static String buildReqResBodyJson(List<YapiCatItemParam> yapiCatItemParamList) {
        Map<String, Object> resBodyMap = YapiBuilder.adapterResBodyParam(null, yapiCatItemParamList);
        if (Objects.isNull(resBodyMap)) {
            return "";
        }
        return JSON.toJSONString(resBodyMap);
    }

    private static Map<String, Object> adapterResBodyParam(String description, List<YapiCatItemParam> yapiCatItemParamList) {
        if (Objects.isNull(yapiCatItemParamList) || 0 == yapiCatItemParamList.size()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList<String> requiredParams = new ArrayList<String>();
        for (YapiCatItemParam itemParam : yapiCatItemParamList) {
            List<YapiCatItemParam> childrens = itemParam.getChildrens();
            if (Objects.nonNull(childrens) && 0 < childrens.size()) {
                Map<String, Object> childrenMap = YapiBuilder.adapterResBodyParam(itemParam.getDesc(), childrens);
                paramMap.put(itemParam.getName(), childrenMap);
            } else {
                paramMap.put(itemParam.getName(), new PropertiesItem(itemParam.getType(), itemParam.getDesc()));
            }
            if (!itemParam.getRequired().booleanValue()) continue;
            requiredParams.add(itemParam.getName());
        }
        HashMap<String, Object> resBodyMap = new HashMap<String, Object>(3);
        resBodyMap.put("properties", paramMap);
        resBodyMap.put("required", requiredParams);
        resBodyMap.put("description", description);
        return resBodyMap;
    }

    private static List<YapiCatItemParam> adapterSmartDocHeadersParam(List<ApiReqParam> apiReqParamList) {
        if (Objects.isNull(apiReqParamList) || 0 == apiReqParamList.size()) {
            return null;
        }
        ArrayList<YapiCatItemParam> yapiCatItemParamList = new ArrayList<YapiCatItemParam>();
        for (ApiReqParam apiReqParam : apiReqParamList) {
            YapiCatItemParam yapiCatItemParam = YapiCatItemParam.builder().name(apiReqParam.getName()).desc(apiReqParam.getDesc()).value(apiReqParam.getValue()).required(apiReqParam.isRequired()).type(apiReqParam.getType()).build();
            yapiCatItemParamList.add(yapiCatItemParam);
        }
        return yapiCatItemParamList;
    }

    private static List<YapiCatItemParam> adapterSmartDocParam(List<ApiParam> apiParamList) {
        ArrayList<YapiCatItemParam> yapiCatItemParamList = new ArrayList<YapiCatItemParam>();
        for (ApiParam apiParam : apiParamList) {
            YapiCatItemParam yapiCatItemParam = YapiCatItemParam.builder().name(apiParam.getField()).desc(apiParam.getDesc()).required(apiParam.isRequired()).type(apiParam.getType()).build();
            if ("object".equals(apiParam.getType()) && 0 < apiParam.getChildren().size()) {
                List<YapiCatItemParam> childrens = YapiBuilder.adapterSmartDocParam(apiParam.getChildren());
                yapiCatItemParam.setChildrens(childrens);
            }
            yapiCatItemParamList.add(yapiCatItemParam);
        }
        return yapiCatItemParamList;
    }

    private static String adapterRequired(boolean required) {
        if (required) {
            return "1";
        }
        return "0";
    }
}

