/*
 * Decompiled with CFR 0.152.
 */
package cn.dlysxx.www.common.crypto;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class AESCryptoUtil {
    public static byte[] encryptString(String plainText, String password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] textByte = plainText.getBytes(StandardCharsets.UTF_8);
        return AESCryptoUtil.encrypt(textByte, password);
    }

    public static byte[] decryptString(String encrypted, String password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return AESCryptoUtil.decrypt(Base64.getDecoder().decode(encrypted.getBytes(StandardCharsets.UTF_8)), password);
    }

    public static void encryptFile(String inputFilePath, String outputFilePath, String password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
        File input = new File(inputFilePath);
        byte[] content = FileUtils.readFileToByteArray((File)input);
        byte[] encrypted = AESCryptoUtil.encrypt(content, password);
        FileUtils.writeByteArrayToFile((File)new File(outputFilePath), (byte[])encrypted);
    }

    public static void decryptFile(String inputFilePath, String outputFilePath, String password) throws IOException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] encryptedData = FileUtils.readFileToByteArray((File)new File(inputFilePath));
        byte[] decrypted = AESCryptoUtil.decrypt(encryptedData, password);
        FileUtils.writeByteArrayToFile((File)new File(outputFilePath), (byte[])decrypted);
    }

    private static void getKeyAndGenerateIv(String password, byte[] salt, byte[] keyBytes, byte[] ivBytes) {
        try {
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            int length = passwordBytes.length + salt.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(length);
            byteBuffer.put(passwordBytes);
            byteBuffer.put(salt);
            byteBuffer.rewind();
            byte[] byteArray = new byte[length];
            byteBuffer.get(byteArray);
            System.arraycopy(MessageDigest.getInstance("MD5").digest(byteArray), 0, keyBytes, 0, keyBytes.length);
            length = passwordBytes.length + salt.length + keyBytes.length;
            byteBuffer = ByteBuffer.allocate(length);
            byteBuffer.put(keyBytes);
            byteBuffer.put(passwordBytes);
            byteBuffer.put(salt);
            byteBuffer.rewind();
            byteArray = new byte[length];
            byteBuffer.get(byteArray);
            System.arraycopy(MessageDigest.getInstance("MD5").digest(byteArray), 0, ivBytes, 0, ivBytes.length);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private static byte[] encrypt(byte[] plaintext, String password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] randomBytes = new byte[8];
        new SecureRandom().nextBytes(randomBytes);
        byte[] keyBytes = new byte[16];
        byte[] ivBytes = new byte[16];
        AESCryptoUtil.getKeyAndGenerateIv(password, randomBytes, keyBytes, ivBytes);
        SecretKeySpec secret = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        assert (cipher != null);
        cipher.init(1, (Key)secret, ivSpec);
        byte[] encryptedBytes = cipher.doFinal(plaintext);
        String header_string = "Salted__";
        byte[] headerBytes = "Salted__".getBytes(StandardCharsets.UTF_8);
        int length = headerBytes.length + randomBytes.length + encryptedBytes.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(headerBytes);
        byteBuffer.put(randomBytes);
        byteBuffer.put(encryptedBytes);
        byteBuffer.rewind();
        byte[] byteArray = new byte[length];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    private static byte[] decrypt(byte[] payloadBytes, String password) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] headerBytes = new byte[8];
        byte[] saltBytes = new byte[8];
        int length = payloadBytes.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put(payloadBytes);
        byteBuffer.rewind();
        byteBuffer.get(headerBytes);
        byteBuffer.get(saltBytes);
        length = payloadBytes.length - headerBytes.length - saltBytes.length;
        byte[] dataBytes = new byte[length];
        byteBuffer.get(dataBytes);
        byte[] keyByte = new byte[16];
        byte[] ivBytes = new byte[16];
        AESCryptoUtil.getKeyAndGenerateIv(password, saltBytes, keyByte, ivBytes);
        SecretKeySpec secret = new SecretKeySpec(keyByte, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
        assert (cipher != null);
        cipher.init(2, (Key)secret, ivSpec);
        return cipher.doFinal(dataBytes);
    }
}

