/*
 * Decompiled with CFR 0.152.
 */
package cn.dlysxx.www.common.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String ISO_ZONED_DATE_TIME = "uuuu-MM-dd'T'HH:mm:ss.SSSxxx'['VV']'";
    public static final String ISO_LOCAL_DATE_TIME = "uuuu-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO_LOCAL_DATE = "uuuu-MM-dd";
    public static final String ISO_LOCAL_TIME = "HH:mm:ss.SSS";
    public static final String UU = "uu";
    public static final String UUUU = "uuuu";
    public static final String MM = "MM";
    public static final String UUMM = "uuMM";
    public static final String UUUUMM = "uuuuMM";
    public static final String UUUUMM_HYPHEN = "uuuu-MM";
    public static final String UUUUMM_SLASH = "uuuu/MM";
    public static final String UUUUMMDD = "uuuuMMdd";
    public static final String UUUUMMDD_SLASH = "uuuu/MM/dd";
    public static final String UUUUMMDDHHMM = "uuuuMMddHHmm";
    public static final String UUUUMMDDHHMM_HYPHEN = "uuuu-MM-dd HH:mm";
    public static final String UUUUMMDDHHMM_SLASH = "uuuu/MM/dd HH:mm";
    public static final String UUUUMMDDHHMMSS = "uuuuMMddHHmmss";
    public static final String UUUUMMDDHHMMSS_HYPHEN = "uuuu-MM-dd HH:mm:ss";
    public static final String UUUUMMDDHHMMSS_SLASH = "uuuu/MM/dd HH:mm:ss";
    public static final String UUUUMMDDHHMMSSSSS = "uuuuMMddHHmmssSSS";
    public static final String UUUUMMDDHHMMSSSSS_HYPHEN = "uuuu-MM-dd HH:mm:ss.SSS";
    public static final String UUUUMMDDHHMMSSSSS_SLASH = "uuuu/MM/dd HH:mm:ss.SSS";
    public static final String HHMMSS_TIME = "HH:mm:ss";
    public static final String HHMMSS = "HHmmss";
    public static final String HHMMSSSSS = "HHmmssSSS";
    private static final Map<String, DateTimeFormatter> CACHE_DATE_TIME_FORMATTER = new ConcurrentHashMap<String, DateTimeFormatter>();

    private static DateTimeFormatter getDateTimeFormatter(String format) {
        return CACHE_DATE_TIME_FORMATTER.computeIfAbsent(format, v -> DateTimeFormatter.ofPattern(format).withResolverStyle(ResolverStyle.STRICT));
    }

    public static ZonedDateTime nowZonedDateTime(String timeZone) {
        return ZonedDateTime.now(ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static LocalDateTime nowLocalDateTime(String timeZone) {
        return DateUtil.nowZonedDateTime(timeZone).toLocalDateTime();
    }

    public static LocalDate nowLocalDate(String timeZone) {
        return DateUtil.nowZonedDateTime(timeZone).toLocalDate();
    }

    public static LocalTime nowLocalTime(String timeZone) {
        return DateUtil.nowZonedDateTime(timeZone).toLocalTime();
    }

    public static Date nowDate(String timeZone) {
        ZonedDateTime zoned = DateUtil.nowZonedDateTime(timeZone);
        return Date.from(zoned.toLocalDateTime().toInstant(ZonedDateTime.now().getOffset()));
    }

    public static Calendar nowCalendar(String timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.nowDate(timeZone));
        return cal;
    }

    public static YearMonth nowYearMonth(String timeZone) {
        return YearMonth.from(DateUtil.nowLocalDate(timeZone));
    }

    public static String nowString(String format, String timeZone) {
        ZonedDateTime zoned = DateUtil.nowZonedDateTime(timeZone);
        return DateUtil.toString(zoned, format);
    }

    public static ZonedDateTime toZonedDateTime(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.withZoneSameInstant(ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime, String timeZone) {
        if (localDateTime == null) {
            return null;
        }
        return ZonedDateTime.of(localDateTime, ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate, String timeZone) {
        if (localDate == null) {
            return null;
        }
        return ZonedDateTime.of(localDate.atStartOfDay(), ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static ZonedDateTime toZonedDateTime(LocalTime localTime, String timeZone) {
        if (localTime == null) {
            return null;
        }
        return ZonedDateTime.of(localTime.atDate(DateUtil.nowLocalDate(timeZone)), ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static ZonedDateTime toZonedDateTime(Date date, String timeZone) {
        if (date == null) {
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return ZonedDateTime.of(localDateTime, ZoneId.of(timeZone, ZoneId.SHORT_IDS));
    }

    public static ZonedDateTime toZonedDateTime(Calendar cal, String timeZone) {
        if (cal == null) {
            return null;
        }
        return DateUtil.toZonedDateTime(cal.getTime(), timeZone);
    }

    public static ZonedDateTime toZonedDateTime(String str, String formatWithTimeZone) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return ZonedDateTime.from(DateUtil.getDateTimeFormatter(formatWithTimeZone).parse(str));
    }

    public static ZonedDateTime toZonedDateTime(String str, String formatWithoutTimeZone, String timeZone) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return DateUtil.toZonedDateTime(DateUtil.toLocalDateTime(str, formatWithoutTimeZone), timeZone);
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.withZoneSameInstant(ZoneId.of(timeZone, ZoneId.SHORT_IDS)).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDateTime localDateTime, ZoneId from, ZoneId to) {
        if (localDateTime == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(ZonedDateTime.of(localDateTime, from).toInstant(), to).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(LocalTime localTime, String timeZone) {
        if (localTime == null) {
            return null;
        }
        return localTime.atDate(DateUtil.nowLocalDate(timeZone));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(cal.getTime());
    }

    public static LocalDateTime toLocalDateTime(String str, String format) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return LocalDateTime.from(DateUtil.getDateTimeFormatter(format).parse(str));
    }

    public static LocalDate toLocalDate(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(zonedDateTime, timeZone).toLocalDate();
    }

    public static LocalDate toLocalDate(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(zonedDateTime).toLocalDate();
    }

    public static LocalDate toLocalDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return DateUtil.toLocalDate(cal.getTime());
    }

    public static LocalDate toLocalDate(String str, String format) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return LocalDate.from(DateUtil.getDateTimeFormatter(format).parse(str));
    }

    public static LocalTime toLocalTime(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(zonedDateTime, timeZone).toLocalTime();
    }

    public static LocalTime toLocalTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(zonedDateTime).toLocalTime();
    }

    public static LocalTime toLocalTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toLocalTime();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.toLocalDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(String str, String format) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return LocalTime.from(DateUtil.getDateTimeFormatter(format).parse(str));
    }

    public static Date toDate(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toDate(DateUtil.toLocalDateTime(zonedDateTime, timeZone));
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toDate(DateUtil.toLocalDateTime(zonedDateTime));
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.toInstant(ZonedDateTime.now().getOffset()));
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().toInstant(ZonedDateTime.now().getOffset()));
    }

    public static Date toDate(LocalTime localTime, String timeZone) {
        if (localTime == null) {
            return null;
        }
        return Date.from(localTime.atDate(DateUtil.nowLocalDate(timeZone)).toInstant(ZonedDateTime.now().getOffset()));
    }

    public static Date toDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.getTime();
    }

    public static Date toDate(String str, String format) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        TemporalAccessor temporal = DateUtil.getDateTimeFormatter(format).parse(str);
        LocalDate date = temporal.query(TemporalQueries.localDate());
        LocalTime time = temporal.query(TemporalQueries.localTime());
        if (time != null) {
            return DateUtil.toDate(LocalDateTime.of(date, time));
        }
        return DateUtil.toDate(date.atStartOfDay());
    }

    public static Calendar toCalendar(ZonedDateTime zonedDateTime, String timeZone) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toCalendar(DateUtil.toDate(zonedDateTime, timeZone));
    }

    public static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        return DateUtil.toCalendar(DateUtil.toDate(zonedDateTime));
    }

    public static Calendar toCalendar(LocalDateTime localDateTime) {
        return DateUtil.toCalendar(DateUtil.toDate(localDateTime));
    }

    public static Calendar toCalendar(LocalDate localDate) {
        return DateUtil.toCalendar(DateUtil.toDate(localDate));
    }

    public static Calendar toCalendar(LocalTime localTime, String timeZone) {
        return DateUtil.toCalendar(DateUtil.toDate(localTime, timeZone));
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar toCalendar(String str, String format) {
        return DateUtil.toCalendar(DateUtil.toDate(str, format));
    }

    public static YearMonth toYearMonth(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return YearMonth.of(cal.get(1), cal.get(2) + 1);
    }

    public static YearMonth toYearMonth(String str, String format) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return YearMonth.from(DateUtil.getDateTimeFormatter(format).parse(str));
    }

    public static String toString(ZonedDateTime zonedDateTime, String timeZone, String format) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.toString(DateUtil.toZonedDateTime(zonedDateTime, timeZone), format);
    }

    public static String toString(ZonedDateTime zonedDateTime, String format) {
        if (zonedDateTime == null) {
            return null;
        }
        return DateUtil.getDateTimeFormatter(format).format(zonedDateTime);
    }

    public static String toString(LocalDateTime localDateTime, String format) {
        if (localDateTime == null) {
            return null;
        }
        return DateUtil.getDateTimeFormatter(format).format(localDateTime);
    }

    public static String toString(LocalDate localDate, String format) {
        if (localDate == null) {
            return null;
        }
        return DateUtil.getDateTimeFormatter(format).format(localDate.atStartOfDay());
    }

    public static String toString(LocalTime localTime, String format) {
        if (localTime == null) {
            return null;
        }
        return DateUtil.getDateTimeFormatter(format).format(localTime);
    }

    public static String toString(Date date, String format) {
        if (date == null) {
            return null;
        }
        return DateUtil.toString(DateUtil.toLocalDateTime(date), format);
    }

    public static String toString(Calendar cal, String format) {
        if (cal == null) {
            return null;
        }
        return DateUtil.toString(DateUtil.toLocalDateTime(cal), format);
    }

    public static String toString(YearMonth yearMonth, String format) {
        if (yearMonth == null) {
            return null;
        }
        return DateUtil.getDateTimeFormatter(format).format(yearMonth);
    }

    public static boolean isIntime(Date start, Date end, Date target) {
        return target.equals(start) || target.equals(end) || target.after(start) && target.before(end);
    }
}

