/*
 * Decompiled with CFR 0.152.
 */
package cn.dlysxx.www.common.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipUtil {
    public static File compressToZip(String fileName, List<File> files) throws IOException {
        File zipFile = File.createTempFile(fileName, "zip");
        ZipArchiveOutputStream os = new ZipArchiveOutputStream(zipFile);
        for (File f : files) {
            ZipArchiveEntry entry = new ZipArchiveEntry(f, f.getName());
            os.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)os);
        }
        os.closeArchiveEntry();
        os.finish();
        return zipFile;
    }

    public static void decompressFromZip(InputStream input, List<File> files) throws IOException {
        ZipArchiveEntry entry;
        ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)new BufferedInputStream(input));
        while ((entry = archive.getNextZipEntry()) != null) {
            String fileName = entry.getName();
            System.out.println(fileName);
            File file = File.createTempFile(fileName.substring(0, fileName.lastIndexOf(".")), fileName.substring(fileName.lastIndexOf(".")));
            IOUtils.copy((InputStream)archive, (OutputStream)new FileOutputStream(file));
            files.add(file);
        }
    }
}

