/*
 * Decompiled with CFR 0.152.
 */
package cn.dlysxx.www.common.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final String CHARSET_NAME = "UTF-8";

    public static String conversion(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CHARSET_NAME));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String mask(String str, int range, boolean direction, char mask, String allow) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (str.length() <= range || range <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        if (direction) {
            for (int i = 0; i < str.length() - range; ++i) {
                String c = String.valueOf(str.charAt(i));
                if (!StringUtils.isEmpty((CharSequence)allow) && c.matches(allow)) {
                    sb.append(c);
                    continue;
                }
                sb.append(mask);
            }
            sb.append(str.substring(str.length() - range));
        } else {
            sb.append(str.substring(0, range));
            for (int i = range; i < str.length(); ++i) {
                String c = String.valueOf(str.charAt(i));
                if (!StringUtils.isEmpty((CharSequence)allow) && c.matches(allow)) {
                    sb.append(c);
                    continue;
                }
                sb.append(mask);
            }
        }
        return sb.toString();
    }
}

