package cn.donecro.util;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;


public class DonHeaders {

    @Getter
    protected Builder tBuilder;

    public DonHeaders() {
        tBuilder = new Builder();
    }

    public Builder createBuilder() {
        Builder builder = new Builder(this);
        tBuilder = builder;
        return builder;
    }
    
    public static Builder newBuilder() {
        return (new DonHeaders()).createBuilder();
    }

    protected abstract static class GeneratedBuilder {

        @Getter
        protected List<Header> headers;

        protected GeneratedBuilder() {
            super();
            headers = new ArrayList<>();
        }
        
        protected void createHeader(String key, Object value) {
            if (key == null) throw new RuntimeException("Key cannot be null");
            if (value == null) throw new RuntimeException("Value cannot be null");
            headers.add(new Header(key, value));
        }

        public Builder addHeader(String key, Object value) {
            createHeader(key, value);
            return (Builder) this;
        }
    }

    @NoArgsConstructor
    public static class Builder extends GeneratedBuilder {

        private DonHeaders headers;

        protected Builder(DonHeaders headers) {
            super();
            this.headers = headers;
        }

        public DonHeaders toHeaders() {
            return this.headers;
        }
    }

    @Getter
    @ToString
    public static class Header {
        private final String key;
        private final Object value;

        protected Header(String key, Object value) {
            super();
            this.key = key;
            this.value = value;
        }
    }
    
}