package cn.donecro.util;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;


public class DonParams {

    @Getter
    protected Builder tBuilder;

    public DonParams() {
        tBuilder = new Builder();
    }

    public Builder createBuilder() {
        Builder builder = new Builder(this);
        tBuilder = builder;
        return builder;
    }
    
    public static Builder newBuilder() {
        return (new DonParams()).createBuilder();
    }

    protected abstract static class GeneratedBuilder {

        @Getter
        protected List<Param> params;

        protected GeneratedBuilder() {
            super();
            params = new ArrayList<>();
        }
        
        protected void createParam(String key, Object value) {
            if (key == null) throw new RuntimeException("Key cannot be null");
            if (value == null) throw new RuntimeException("Value cannot be null");
            params.add(new Param(key, value));
        }

        public Builder addParam(String key, Object value) {
            createParam(key, value);
            return (Builder) this;
        }
    }

    @NoArgsConstructor
    public static class Builder extends GeneratedBuilder {

        private DonParams params;

        protected Builder(DonParams params) {
            super();
            this.params = params;
        }

        public DonParams toParams() {
            return this.params;
        }
    }

    @Getter
    @ToString
    public static class Param {
        private final String key;
        private final Object value;

        protected Param(String key, Object value) {
            super();
            this.key = key;
            this.value = value;
        }
    }
    
}