package cn.donecro.util;


import com.alibaba.fastjson.JSONObject;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.function.Consumer;

public class HttpsRequest {
    public static void doRequestWithSSL(
            String link,
            String method,
            Map<String, String> headers,
            String param,
            Consumer<JSONObject> c)
            throws IOException, NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        TrustManager[] trustManagers = {new MyX509TrustManager()};
        sslContext.init(null, trustManagers, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        StringBuffer buffer;
        URL url = new URL(link);
        HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
        conn.setRequestMethod(method);
        headers.forEach(conn::setRequestProperty);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setSSLSocketFactory(sslSocketFactory);
        conn.connect();
        if (param != null) {
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(param.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        InputStream inputStream = conn.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        buffer = new StringBuffer();
        String line;
        while ((line = bufferedReader.readLine()) != null) buffer.append(line);
        System.out.println(buffer.toString());
        c.accept(JSONObject.parseObject(buffer.toString()));
    }

    public static void doRequest(
            String link,
            String method,
            Map<String, String> headers,
            String param,
            Consumer<JSONObject> c)
            throws IOException {

        StringBuffer buffer;
        URL url = new URL(link);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setRequestMethod(method);
        headers.forEach(conn::setRequestProperty);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.connect();
        if (param != null) {
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(param.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        InputStream inputStream = conn.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        buffer = new StringBuffer();
        String line;
        while ((line = bufferedReader.readLine()) != null) buffer.append(line);
        System.out.println(buffer.toString());
        c.accept(JSONObject.parseObject(buffer.toString()));
    }
}