/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.call.path.LiteralPathResolver;
import cn.duskykite.open.call.path.PathResolver;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.hc.core5.net.URIBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public record Path(@NonNull Collection<? extends PathResolver> resolvers) {
    public Path(@NonNull Collection<? extends PathResolver> resolvers) {
        if (resolvers == null) {
            throw new NullPointerException("resolvers is marked non-null but is null");
        }
        this.resolvers = resolvers = ImmutableList.copyOf(resolvers);
    }

    public Path(@NonNull String path) {
        this(List.of(new LiteralPathResolver(path)));
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String resolve(Collection<@Nullable String> variables) {
        URIBuilder builder = new URIBuilder();
        Iterator iterator = Optional.ofNullable(variables).map(Collection::iterator).orElse(null);
        this.resolvers.forEach(resolver -> resolver.resolve(builder, iterator));
        return builder.toString();
    }

    @Override
    @NonNull
    public String toString() {
        return this.resolve(null);
    }

    public record Builder(@NonNull Collection<PathResolver> resolvers) {
        public Builder(@NonNull Collection<PathResolver> resolvers) {
            if (resolvers == null) {
                throw new NullPointerException("resolvers is marked non-null but is null");
            }
        }

        public Builder() {
            this(new LinkedList<PathResolver>());
        }

        @NonNull
        public Path build() {
            return new Path(this.resolvers);
        }

        @NonNull
        public Builder append(@NonNull PathResolver resolver) {
            if (resolver == null) {
                throw new NullPointerException("resolver is marked non-null but is null");
            }
            this.resolvers.add(resolver);
            return this;
        }

        @NonNull
        public Builder appendLiteral(@NonNull String literal) {
            if (literal == null) {
                throw new NullPointerException("literal is marked non-null but is null");
            }
            return this.append(new LiteralPathResolver(literal));
        }

        @NonNull
        public Builder appendPathVariable(@NonNull String variable) {
            if (variable == null) {
                throw new NullPointerException("variable is marked non-null but is null");
            }
            return this.append(() -> variable);
        }

        @NonNull
        public Builder appendQuery(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return this.append(() -> name);
        }
    }
}

