/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.GsonSupport;
import cn.duskykite.open.call.APIEnum;
import cn.duskykite.open.call.Response;
import cn.duskykite.open.call.Result;
import cn.duskykite.open.call.requestbody.PatchIMV1MessagesMessageIdRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3AppAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenInternalRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1ImageRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesMessageIdReplyRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesRequestBody;
import cn.duskykite.open.call.requestbody.PostInteractiveV1CardUpdateRequestBody;
import cn.duskykite.open.call.requestbody.PostMessageV4BatchSendRequestBody;
import cn.duskykite.open.call.result.DataResult;
import cn.duskykite.open.call.result.PostAuthV3AppAccessTokenResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenInternalResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenResult;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdChildrenData;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdData;
import cn.duskykite.open.call.result.data.GetContactV3ScopesData;
import cn.duskykite.open.call.result.data.GetContactV3UsersFindByDepartmentData;
import cn.duskykite.open.call.result.data.GetContactV3UsersUserIdData;
import cn.duskykite.open.call.result.data.IMV1Messages;
import cn.duskykite.open.call.result.data.PostIMV1ImageData;
import cn.duskykite.open.call.result.data.PostMessageV4BatchSendData;
import cn.duskykite.open.call.result.mapper.ByteResultMapper;
import cn.duskykite.open.call.result.mapper.JsonResultMapper;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public record SAO(@NonNull HttpUrl primaryURL, @NonNull OkHttpClient client) {
    @NonNull
    public static final MediaType APPLICATION_JSON_UTF_8 = Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8"));
    @NonNull
    public static final Headers JSON_CONTENT_TYPE_HEADERS = SAO.toContentTypeHeaders(APPLICATION_JSON_UTF_8);

    public SAO(@NonNull HttpUrl primaryURL, @NonNull OkHttpClient client) {
        if (primaryURL == null) {
            throw new NullPointerException("primaryURL is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
    }

    @NonNull
    public static Headers toContentTypeHeaders(@NonNull MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Content-Type", mediaType.toString()});
    }

    @NonNull
    public static Headers toTokenHeaders(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Authorization", "Bearer " + token});
    }

    @NonNull
    public <T> Response<T> get(@NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(Request.Builder::get, path, headers, resultMapper);
    }

    @NonNull
    public <T> Response<T> post(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.post(body), path, headers, resultMapper);
    }

    @NonNull
    public <T> Response<T> patch(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.patch(body), path, headers, resultMapper);
    }

    @NonNull
    public <T> Response<T> delete(@NonNull String path, Headers headers, RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.delete(body), path, headers, resultMapper);
    }

    @NonNull
    public Response<PostAuthV3AppAccessTokenResult> postAuthV3AppAccessToken(@NonNull PostAuthV3AppAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.AUTH_V3_APP_ACCESS_TOKEN, null, List.of(JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), PostAuthV3AppAccessTokenResult.class);
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenResult> postAuthV3TenantAccessToken(@NonNull PostAuthV3TenantAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.AUTH_V3_TENANT_ACCESS_TOKEN, null, List.of(JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), PostAuthV3TenantAccessTokenResult.class);
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenInternalResult> postAuthV3TenantAccessTokenInternal(@NonNull PostAuthV3TenantAccessTokenInternalRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.AUTH_V3_TENANT_ACCESS_TOKEN_INTERNAL, null, List.of(JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), PostAuthV3TenantAccessTokenInternalResult.class);
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdData>> getContactV3DepartmentsDepartmentId(@NonNull String tenantAccessTokenOrUserAccessToken, @NonNull String departmentId, String userIdType, String departmentIdType) {
        if (tenantAccessTokenOrUserAccessToken == null) {
            throw new NullPointerException("tenantAccessTokenOrUserAccessToken is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(APIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID, Stream.of(departmentId, userIdType, departmentIdType).toList(), List.of(SAO.toTokenHeaders(tenantAccessTokenOrUserAccessToken)), new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdData>>(){});
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>> getContactV3DepartmentsDepartmentIdChildren(@NonNull String tenantAccessTokenOrUserAccessToken, @NonNull String departmentId, String userIdType, String departmentIdType, Boolean fetchChild, Integer pageSize, String pageToken) {
        if (tenantAccessTokenOrUserAccessToken == null) {
            throw new NullPointerException("tenantAccessTokenOrUserAccessToken is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(APIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID_CHILDREN, Stream.of(departmentId, userIdType, departmentIdType, fetchChild, pageSize, pageToken).toList(), List.of(SAO.toTokenHeaders(tenantAccessTokenOrUserAccessToken)), new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>>(){});
    }

    @NonNull
    public Response<DataResult<GetContactV3ScopesData>> getContactV3Scopes(@NonNull String tenantAccessToken, String userIdType, String departmentIdType, String pageToken, Integer pageSize) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        return this.get(APIEnum.CONTACT_V3_SCOPES, Stream.of(userIdType, departmentIdType, pageToken, pageSize).toList(), List.of(SAO.toTokenHeaders(tenantAccessToken)), new TypeToken<DataResult<GetContactV3ScopesData>>(){});
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersFindByDepartmentData>> getContactV3UsersFindByDepartment(@NonNull String tenantAccessTokenOrUserAccessToken, String userIdType, String departmentIdType, @NonNull String departmentId, Integer pageSize, String pageToken) {
        if (tenantAccessTokenOrUserAccessToken == null) {
            throw new NullPointerException("tenantAccessTokenOrUserAccessToken is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(APIEnum.CONTACT_V3_USERS_FIND_BY_DEPARTMENT, Stream.of(userIdType, departmentIdType, departmentId, pageSize, pageToken).toList(), List.of(SAO.toTokenHeaders(tenantAccessTokenOrUserAccessToken)), new TypeToken<DataResult<GetContactV3UsersFindByDepartmentData>>(){});
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersUserIdData>> getContactV3UsersUserId(@NonNull String tenantAccessTokenOrUserAccessToken, @NonNull String userId, String userIdType, String departmentIdType) {
        if (tenantAccessTokenOrUserAccessToken == null) {
            throw new NullPointerException("tenantAccessTokenOrUserAccessToken is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        return this.get(APIEnum.CONTACT_V3_USERS_USER_ID, Stream.of(userId, userIdType, departmentIdType).toList(), List.of(SAO.toTokenHeaders(tenantAccessTokenOrUserAccessToken)), new TypeToken<DataResult<GetContactV3UsersUserIdData>>(){});
    }

    @NonNull
    public Response<DataResult<PostIMV1ImageData>> postIMV1Image(@NonNull String tenantAccessToken, @NonNull PostIMV1ImageRequestBody body) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        MultipartBody multipartBody = body.newMultipartBody();
        return this.post(APIEnum.IM_V1_IMAGE, null, List.of(SAO.toTokenHeaders(tenantAccessToken), SAO.toContentTypeHeaders(multipartBody.contentType())), (RequestBody)multipartBody, new TypeToken<DataResult<PostIMV1ImageData>>(){});
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1Messages(@NonNull String tenantAccessToken, @NonNull String receiveIdType, @NonNull PostIMV1MessagesRequestBody body) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (receiveIdType == null) {
            throw new NullPointerException("receiveIdType is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.IM_V1_MESSAGES, List.of(receiveIdType), List.of(SAO.toTokenHeaders(tenantAccessToken), JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), new TypeToken<DataResult<IMV1Messages>>(){});
    }

    @NonNull
    public Response<DataResult<Object>> patchIMV1MessagesMessageId(@NonNull String tenantAccessTokenOrUserAccessToken, @NonNull String messageId, @NonNull PatchIMV1MessagesMessageIdRequestBody body) {
        if (tenantAccessTokenOrUserAccessToken == null) {
            throw new NullPointerException("tenantAccessTokenOrUserAccessToken is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.patch(APIEnum.IM_V1_MESSAGES_MESSAGE_ID, List.of(messageId), List.of(SAO.toTokenHeaders(tenantAccessTokenOrUserAccessToken), JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), new TypeToken<DataResult<Object>>(){});
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1MessagesMessageIdReply(@NonNull String tenantAccessToken, @NonNull String messageId, @NonNull PostIMV1MessagesMessageIdReplyRequestBody body) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.IM_V1_MESSAGES_MESSAGE_ID_REPLY, List.of(messageId), List.of(SAO.toTokenHeaders(tenantAccessToken), JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), new TypeToken<DataResult<IMV1Messages>>(){});
    }

    @NonNull
    public Response<byte[]> getIMV1MessagesResources(@NonNull String tenantAccessToken, @NonNull String messageId, @NonNull String fileKey, @NonNull String type) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (fileKey == null) {
            throw new NullPointerException("fileKey is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.get(APIEnum.IM_V1_MESSAGES_RESOURCES, List.of(messageId, fileKey, type), List.of(SAO.toTokenHeaders(tenantAccessToken)));
    }

    @NonNull
    public Response<Result> postInteractiveV1CardUpdate(@NonNull String tenantAccessToken, @NonNull PostInteractiveV1CardUpdateRequestBody body) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.INTERACTIVE_V1_CARD_UPDATE, null, List.of(SAO.toTokenHeaders(tenantAccessToken), JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), new TypeToken<Result>(){});
    }

    @NonNull
    public Response<DataResult<PostMessageV4BatchSendData>> postMessageV4BatchSend(@NonNull String tenantAccessToken, @NonNull PostMessageV4BatchSendRequestBody body) {
        if (tenantAccessToken == null) {
            throw new NullPointerException("tenantAccessToken is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(APIEnum.MESSAGE_V4_BATCH_SEND, null, List.of(SAO.toTokenHeaders(tenantAccessToken), JSON_CONTENT_TYPE_HEADERS), this.toJsonRequestBody(body), new TypeToken<DataResult<PostMessageV4BatchSendData>>(){});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull
    private static String toPath(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        @Nullable List variableStrings = Optional.ofNullable(pathVariables).map(variables -> variables.stream().map(variable -> Optional.ofNullable(variable).map(Object::toString).orElse(null)).toList()).orElse(null);
        return apiEnum.getPath().resolve(variableStrings);
    }

    private static Headers join(Collection<Headers> headers) {
        return Optional.ofNullable(headers).map($headers -> $headers.stream().collect(Headers.Builder::new, Headers.Builder::addAll, (builder, other) -> builder.addAll(other.build())).build()).orElse(null);
    }

    @NonNull
    private static <T> JsonResultMapper<T> toJsonResultMapper(@NonNull TypeToken<? extends T> typeToken) {
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return jsonText -> GsonSupport.GSON.fromJson(jsonText, typeToken);
    }

    @NonNull
    private RequestBody toJsonRequestBody(@NonNull Object body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return RequestBody.create((String)GsonSupport.GSON.toJson(body), (MediaType)APPLICATION_JSON_UTF_8);
    }

    @NonNull
    private <T> Response<T> get(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.get(SAO.toPath(apiEnum, pathVariables), SAO.join(headers), resultMapper);
    }

    @NonNull
    private <T> Response<T> get(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull TypeToken<? extends T> typeToken) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return this.get(apiEnum, pathVariables, headers, SAO.toJsonResultMapper(typeToken));
    }

    @NonNull
    private Response<byte[]> get(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        return this.get(apiEnum, pathVariables, headers, new ByteResultMapper(){});
    }

    @NonNull
    private <T> Response<T> post(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.post(SAO.toPath(apiEnum, pathVariables), SAO.join(headers), body, resultMapper);
    }

    @NonNull
    private <T> Response<T> post(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull RequestBody body, @NonNull TypeToken<? extends T> typeToken) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return this.post(apiEnum, pathVariables, headers, body, SAO.toJsonResultMapper(typeToken));
    }

    @NonNull
    private <T> Response<T> post(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull RequestBody body, @NonNull Class<? extends T> resultClass) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass is marked non-null but is null");
        }
        return this.post(apiEnum, pathVariables, headers, body, (ResponseBody jsonText) -> GsonSupport.GSON.fromJson(jsonText, resultClass));
    }

    @NonNull
    private <T> Response<T> patch(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.patch(SAO.toPath(apiEnum, pathVariables), SAO.join(headers), this.toJsonRequestBody(body), resultMapper);
    }

    @NonNull
    private <T> Response<T> patch(@NonNull APIEnum apiEnum, Collection<@Nullable ?> pathVariables, Collection<Headers> headers, @NonNull RequestBody body, @NonNull TypeToken<? extends T> typeToken) {
        if (apiEnum == null) {
            throw new NullPointerException("apiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return this.patch(apiEnum, pathVariables, headers, body, SAO.toJsonResultMapper(typeToken));
    }

    @NonNull
    private <T> Response<T> request(@NonNull UnaryOperator<Request.Builder> method, @NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        Response<T> response;
        block19: {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (resultMapper == null) {
                throw new NullPointerException("resultMapper is marked non-null but is null");
            }
            Request.Builder builder = (Request.Builder)method.apply(new Request.Builder());
            if (Objects.nonNull(headers) && headers.size() > 0) {
                builder = builder.headers(headers);
            }
            Request request = builder.url(this.primaryURL + path).build();
            Call call = this.client.newCall(request);
            okhttp3.Response response2 = call.execute();
            try {
                T result;
                ResponseBody body = response2.body();
                try (Closeable ignored = () -> Optional.ofNullable(body).ifPresent(ResponseBody::close);){
                    result = resultMapper.apply(body);
                }
                response = new Response<T>(response2.code(), response2.headers(), result);
                if (response2 == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("execute http call exception: ", e);
                }
            }
            response2.close();
        }
        return response;
    }
}

