/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call.requestbody;

import cn.duskykite.open.LarkSupport;
import cn.duskykite.open.call.requestbody.MultipartBodyResolver;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.MultipartBody;

public interface MultipartBodyGenerator {
    @NonNull
    public static Stream<Map.Entry<String, MultipartBodyResolver>> toResolverStream(@NonNull Class<?> clz, Object obj) {
        if (clz == null) {
            throw new NullPointerException("clz is marked non-null but is null");
        }
        Field[] fields = clz.getDeclaredFields();
        Stream<Map.Entry<String, MultipartBodyResolver>> stream = Arrays.stream(fields).mapMulti((field, downstream) -> {
            if (field.trySetAccessible()) {
                Object value;
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException ignored) {
                    return;
                }
                if (value instanceof MultipartBodyResolver) {
                    MultipartBodyResolver part = (MultipartBodyResolver)value;
                    downstream.accept(Map.entry(Objects.requireNonNull((String)LarkSupport.FIELD_NAMING_MAPPER.apply(field)), part));
                }
            }
        });
        Class<?> superclass = clz.getSuperclass();
        if (Objects.isNull(superclass) || Objects.class.equals(superclass)) {
            return stream;
        }
        Stream<Map.Entry<String, MultipartBodyResolver>> superstream = MultipartBodyGenerator.toResolverStream(superclass, obj);
        return Stream.concat(superstream, stream);
    }

    @NonNull
    public MediaType type();

    @NonNull
    default public MultipartBody newMultipartBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(this.type());
        MultipartBodyGenerator.toResolverStream(this.getClass(), this).collect(Collectors.toMap(entry -> Objects.requireNonNull((String)entry.getKey()), entry -> Objects.requireNonNull((MultipartBodyResolver)entry.getValue()), (old, latter) -> latter)).forEach((name, resolver) -> resolver.resolve(builder, (String)name));
        return builder.build();
    }
}

