/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.GsonSupport;
import cn.duskykite.open.call.OpenAPIEnum;
import cn.duskykite.open.call.Response;
import cn.duskykite.open.call.Result;
import cn.duskykite.open.call.requestbody.MultipartBodySupplier;
import cn.duskykite.open.call.requestbody.PatchIMV1MessagesMessageIdRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3AppAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenInternalRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1ImageRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesMessageIdReplyRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesRequestBody;
import cn.duskykite.open.call.requestbody.PostInteractiveV1CardUpdateRequestBody;
import cn.duskykite.open.call.requestbody.PostMessageV4BatchSendRequestBody;
import cn.duskykite.open.call.result.DataResult;
import cn.duskykite.open.call.result.PostAuthV3AppAccessTokenResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenInternalResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenResult;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdChildrenData;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdData;
import cn.duskykite.open.call.result.data.GetContactV3ScopesData;
import cn.duskykite.open.call.result.data.GetContactV3UsersFindByDepartmentData;
import cn.duskykite.open.call.result.data.GetContactV3UsersUserIdData;
import cn.duskykite.open.call.result.data.GetIMV1ChatsData;
import cn.duskykite.open.call.result.data.GetIMV1ChatsMembersData;
import cn.duskykite.open.call.result.data.IMV1Messages;
import cn.duskykite.open.call.result.data.PageIterator;
import cn.duskykite.open.call.result.data.PostIMV1ImageData;
import cn.duskykite.open.call.result.data.PostMessageV4BatchSendData;
import cn.duskykite.open.call.result.mapper.ByteResultMapper;
import cn.duskykite.open.call.result.mapper.JsonResultMapper;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SAO {
    @NonNull
    public static final HttpUrl OPENAPI_PRIMARY_URL = Objects.requireNonNull(HttpUrl.parse((String)"https://open.feishu.cn/open-apis"));
    @NonNull
    public static final MediaType APPLICATION_JSON_UTF_8 = Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8"));
    @NonNull
    public static final Headers JSON_CONTENT_TYPE_HEADERS = SAO.toContentTypeHeaders(APPLICATION_JSON_UTF_8);
    @NonNull
    private final HttpUrl primaryURL;
    @NonNull
    private final OkHttpClient client;

    @NonNull
    public static String toAuthorization(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return "Bearer " + token;
    }

    @NonNull
    public static Headers toContentTypeHeaders(@NonNull MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Content-Type", mediaType.toString()});
    }

    @NonNull
    public static Headers toAuthorizationHeaders(@NonNull String authorization) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Authorization", authorization});
    }

    public static <P extends PageIterator, C> C pagingAll(@NonNull Function<String, ? extends P> paging, C identity, @NonNull BiFunction<C, ? super P, C> accumulator) {
        PageIterator page;
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (accumulator == null) {
            throw new NullPointerException("accumulator is marked non-null but is null");
        }
        String pageToken = null;
        do {
            page = (PageIterator)paging.apply(pageToken);
            accumulator.apply(identity, page);
        } while (Objects.nonNull(pageToken = (String)Optional.ofNullable(page).map(PageIterator::$pageToken).orElse(null)));
        return identity;
    }

    @NonNull
    public Response<PostAuthV3AppAccessTokenResult> postAuthV3AppAccessToken(@NonNull PostAuthV3AppAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_APP_ACCESS_TOKEN, null, JSON_CONTENT_TYPE_HEADERS, SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<PostAuthV3AppAccessTokenResult>(){}));
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenResult> postAuthV3TenantAccessToken(@NonNull PostAuthV3TenantAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_TENANT_ACCESS_TOKEN, null, JSON_CONTENT_TYPE_HEADERS, SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<PostAuthV3TenantAccessTokenResult>(){}));
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenInternalResult> postAuthV3TenantAccessTokenInternal(@NonNull PostAuthV3TenantAccessTokenInternalRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_TENANT_ACCESS_TOKEN_INTERNAL, null, JSON_CONTENT_TYPE_HEADERS, SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<PostAuthV3TenantAccessTokenInternalResult>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdData>> getContactV3DepartmentsDepartmentId(@NonNull String authorization, @NonNull String departmentId, String userIdType, String departmentIdType) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID, SAO.variables(departmentId, userIdType, departmentIdType), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>> getContactV3DepartmentsDepartmentIdChildren(@NonNull String authorization, @NonNull String departmentId, String userIdType, String departmentIdType, Boolean fetchChild, Integer pageSize, String pageToken) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID_CHILDREN, SAO.variables(departmentId, userIdType, departmentIdType, fetchChild, pageSize, pageToken), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3ScopesData>> getContactV3Scopes(@NonNull String authorization, String userIdType, String departmentIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_SCOPES, SAO.variables(userIdType, departmentIdType, pageToken, pageSize), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetContactV3ScopesData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersFindByDepartmentData>> getContactV3UsersFindByDepartment(@NonNull String authorization, String userIdType, String departmentIdType, @NonNull String departmentId, Integer pageSize, String pageToken) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_USERS_FIND_BY_DEPARTMENT, SAO.variables(userIdType, departmentIdType, departmentId, pageSize, pageToken), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetContactV3UsersFindByDepartmentData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersUserIdData>> getContactV3UsersUserId(@NonNull String authorization, @NonNull String userId, String userIdType, String departmentIdType) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_USERS_USER_ID, SAO.variables(userId, userIdType, departmentIdType), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetContactV3UsersUserIdData>>(){}));
    }

    @NonNull
    public Response<DataResult<PostIMV1ImageData>> postIMV1Image(@NonNull String authorization, @NonNull PostIMV1ImageRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        MultipartBody multipartBody = SAO.toMultipartBody(body);
        return this.post(OpenAPIEnum.IM_V1_IMAGE, null, SAO.headers(SAO.toAuthorizationHeaders(authorization), SAO.toContentTypeHeaders(multipartBody.contentType())), (RequestBody)multipartBody, SAO.toJsonResultMapper(new TypeToken<DataResult<PostIMV1ImageData>>(){}));
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1Messages(@NonNull String authorization, @NonNull String receiveIdType, @NonNull PostIMV1MessagesRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (receiveIdType == null) {
            throw new NullPointerException("receiveIdType is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.IM_V1_MESSAGES, SAO.variables(receiveIdType), SAO.headers(SAO.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<DataResult<IMV1Messages>>(){}));
    }

    @NonNull
    public Response<DataResult<Object>> patchIMV1MessagesMessageId(@NonNull String authorization, @NonNull String messageId, @NonNull PatchIMV1MessagesMessageIdRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.patch(OpenAPIEnum.IM_V1_MESSAGES_MESSAGE_ID, SAO.variables(messageId), SAO.headers(SAO.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<DataResult<Object>>(){}));
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1MessagesMessageIdReply(@NonNull String authorization, @NonNull String messageId, @NonNull PostIMV1MessagesMessageIdReplyRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.IM_V1_MESSAGES_MESSAGE_ID_REPLY, SAO.variables(messageId), SAO.headers(SAO.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<DataResult<IMV1Messages>>(){}));
    }

    @NonNull
    public Response<byte[]> getIMV1MessagesResources(@NonNull String authorization, @NonNull String messageId, @NonNull String fileKey, @NonNull String type) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (fileKey == null) {
            throw new NullPointerException("fileKey is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_MESSAGES_RESOURCES, SAO.variables(messageId, fileKey, type), SAO.toAuthorizationHeaders(authorization));
    }

    @NonNull
    public Response<Result> postInteractiveV1CardUpdate(@NonNull String authorization, @NonNull PostInteractiveV1CardUpdateRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.INTERACTIVE_V1_CARD_UPDATE, null, SAO.headers(SAO.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<Result>(){}));
    }

    @NonNull
    public Response<DataResult<PostMessageV4BatchSendData>> postMessageV4BatchSend(@NonNull String authorization, @NonNull PostMessageV4BatchSendRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.MESSAGE_V4_BATCH_SEND, null, SAO.headers(SAO.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAO.toJsonRequestBody(body), SAO.toJsonResultMapper(new TypeToken<DataResult<PostMessageV4BatchSendData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetIMV1ChatsData>> getIMV1Chats(@NonNull String authorization, String userIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_CHATS, SAO.variables(userIdType, pageToken, pageSize), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetIMV1ChatsData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetIMV1ChatsMembersData>> getIMV1ChatsMembers(@NonNull String authorization, @NonNull String chatId, String memberIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_CHATS_MEMBERS, SAO.variables(chatId, memberIdType, pageToken, pageSize), SAO.toAuthorizationHeaders(authorization), SAO.toJsonResultMapper(new TypeToken<DataResult<GetIMV1ChatsMembersData>>(){}));
    }

    protected static @NonNull List<@Nullable String> variables(Object ... variables) {
        return Optional.ofNullable(variables).filter($variables -> ((Object[])$variables).length > 0).map($variables -> Stream.of($variables).map(variable -> Optional.ofNullable(variable).map(Object::toString).orElse(null)).toList()).orElseGet(List::of);
    }

    protected static Headers headers(Headers ... headers) {
        return Optional.ofNullable(headers).filter($headers -> ((Headers[])$headers).length > 0).map($headers -> {
            if (((Headers[])$headers).length == 1) {
                return $headers[0];
            }
            return Stream.of($headers).collect(Headers.Builder::new, Headers.Builder::addAll, (builder, other) -> builder.addAll(other.build())).build();
        }).orElse(null);
    }

    @NonNull
    protected static RequestBody toJsonRequestBody(@NonNull Object body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return RequestBody.create((String)GsonSupport.toJson((Object)body), (MediaType)APPLICATION_JSON_UTF_8);
    }

    @NonNull
    protected static MultipartBody toMultipartBody(@NonNull MultipartBodySupplier supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return supplier.get();
    }

    @NonNull
    protected static <T> JsonResultMapper<T> toJsonResultMapper(@NonNull TypeToken<? extends T> typeToken) {
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return jsonText -> GsonSupport.fromJson((String)jsonText, (TypeToken)typeToken);
    }

    @NonNull
    protected <T> Response<T> request(@NonNull UnaryOperator<Request.Builder> method, @NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        Response<T> response;
        block19: {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (resultMapper == null) {
                throw new NullPointerException("resultMapper is marked non-null but is null");
            }
            Request.Builder builder = (Request.Builder)method.apply(new Request.Builder());
            if (Objects.nonNull(headers) && headers.size() > 0) {
                builder = builder.headers(headers);
            }
            Request request = builder.url(this.primaryURL + path).build();
            Call call = this.client.newCall(request);
            okhttp3.Response response2 = call.execute();
            try {
                T result;
                ResponseBody body = response2.body();
                try (Closeable ignored = () -> Optional.ofNullable(body).ifPresent(ResponseBody::close);){
                    result = resultMapper.apply(body);
                }
                response = new Response<T>(response2.code(), response2.headers(), result);
                if (response2 == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("execute http call exception: ", e);
                }
            }
            response2.close();
        }
        return response;
    }

    @NonNull
    protected <T> Response<T> get(@NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(Request.Builder::get, path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> post(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.post(body), path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> patch(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.patch(body), path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> delete(@NonNull String path, Headers headers, RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.delete(body), path, headers, resultMapper);
    }

    @NonNull
    private <T> Response<T> get(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.get(SAO.toPath(openApiEnum, pathVariables), headers, resultMapper);
    }

    @NonNull
    private Response<byte[]> get(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        return this.get(openApiEnum, pathVariables, headers, new ByteResultMapper(){});
    }

    @NonNull
    protected <T> Response<T> post(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.post(openApiEnum.getPath().resolve(pathVariables), headers, body, resultMapper);
    }

    @NonNull
    protected <T> Response<T> patch(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.patch(SAO.toPath(openApiEnum, pathVariables), headers, body, resultMapper);
    }

    @NonNull
    protected <T> Response<T> delete(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.delete(SAO.toPath(openApiEnum, pathVariables), headers, body, resultMapper);
    }

    @NonNull
    private static String toPath(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        return openApiEnum.getPath().resolve(pathVariables);
    }

    public SAO(@NonNull HttpUrl primaryURL, @NonNull OkHttpClient client) {
        if (primaryURL == null) {
            throw new NullPointerException("primaryURL is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.primaryURL = primaryURL;
        this.client = client;
    }
}

