/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call.requestbody;

import cn.duskykite.open.LarkSupport;
import cn.duskykite.open.call.requestbody.MultipartBodyResolver;
import cn.duskykite.open.call.requestbody.MultipartBodySupplier;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import lombok.NonNull;
import okhttp3.MultipartBody;

public interface MultipartBodyFieldResolverGenerator
extends MultipartBodySupplier {
    @NonNull
    public static Stream<Pair<String, MultipartBodyResolver>> toResolverStream(@NonNull Class<?> clz, Object obj) {
        if (clz == null) {
            throw new NullPointerException("clz is marked non-null but is null");
        }
        Field[] fields = clz.getDeclaredFields();
        Stream<Pair<String, MultipartBodyResolver>> stream = Arrays.stream(fields).mapMulti((field, downstream) -> {
            if (field.trySetAccessible()) {
                Object value;
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException ignored) {
                    return;
                }
                if (value instanceof MultipartBodyResolver) {
                    MultipartBodyResolver resolver = (MultipartBodyResolver)value;
                    downstream.accept(new Pair((Object)Objects.requireNonNull((String)LarkSupport.FIELD_NAMING_MAPPER.apply(field)), (Object)resolver));
                }
            }
        });
        Class<?> superclass = clz.getSuperclass();
        if (Objects.isNull(superclass) || Objects.class.equals(superclass)) {
            return stream;
        }
        Stream<Pair<String, MultipartBodyResolver>> superstream = MultipartBodyFieldResolverGenerator.toResolverStream(superclass, obj);
        return Stream.concat(superstream, stream);
    }

    @Override
    @NonNull
    default public MultipartBody get() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(this.type());
        MultipartBodyFieldResolverGenerator.toResolverStream(this.getClass(), this).collect(Collectors.toMap(Pair::component1, Pair::component2, (old, latter) -> latter)).forEach((name, resolver) -> resolver.resolve(builder, (String)name));
        return builder.build();
    }
}

