package cn.duskykite.open.call;

import lombok.NonNull;

import java.util.regex.Pattern;

/**
 * 内容处置信息
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record ContentDisposition(
        // 值
        @NonNull String value
) {

    /**
     * 文件名识别格式
     */
    public static final Pattern FILENAME_PATTERN = Pattern.compile("filename *= *\"([^\"]+)\"");

    /**
     * 获取文件名
     * @return 文件名
     */
    public String getFilename() {
        var matcher = FILENAME_PATTERN.matcher(value);
        return matcher.find() ? matcher.group(1) : null;
    }
}
