package cn.duskykite.open.call;

import cn.duskykite.open.call.path.PathVariableEnum;
import cn.duskykite.open.call.path.QueryEnum;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 飞书开放接口枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum OpenAPIEnum {
    /**
     * 商店应用获取 app_access_token
     */
    AUTH_V3_APP_ACCESS_TOKEN("/auth/v3/app_access_token"),
    /**
     * 商店应用获取 tenant_access_token
     */
    AUTH_V3_TENANT_ACCESS_TOKEN("/auth/v3/tenant_access_token"),
    /**
     * 自建应用获取 tenant_access_token
     */
    AUTH_V3_TENANT_ACCESS_TOKEN_INTERNAL("/auth/v3/tenant_access_token/internal"),
    /**
     * 获取单个部门信息
     */
    CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID(
            Path.builder()
                    .appendLiteral("/contact/v3/departments/")
                    .append(PathVariableEnum.DEPARTMENT_ID)
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID_TYPE)),
    /**
     * 获取子部门列表
     */
    CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID_CHILDREN(
            Path.builder()
                    .appendLiteral("/contact/v3/departments/")
                    .append(PathVariableEnum.DEPARTMENT_ID)
                    .appendLiteral("/children")
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID_TYPE)
                    .append(QueryEnum.FETCH_CHILD)
                    .append(QueryEnum.PAGE_SIZE)
                    .append(QueryEnum.PAGE_TOKEN)),
    /**
     * 获取通讯录授权范围
     */
    CONTACT_V3_SCOPES(
            Path.builder()
                    .appendLiteral("/contact/v3/scopes")
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID_TYPE)
                    .append(QueryEnum.PAGE_TOKEN)
                    .append(QueryEnum.PAGE_SIZE)),
    /**
     * 获取部门直属用户列表
     */
    CONTACT_V3_USERS_FIND_BY_DEPARTMENT(
            Path.builder()
                    .appendLiteral("/contact/v3/users/find_by_department")
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID)
                    .append(QueryEnum.PAGE_SIZE)
                    .append(QueryEnum.PAGE_TOKEN)
                    .build()),
    /**
     * 获取单个用户信息
     */
    CONTACT_V3_USERS_USER_ID(
            Path.builder()
                    .appendLiteral("/contact/v3/users/")
                    .append(PathVariableEnum.USER_ID)
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.DEPARTMENT_ID_TYPE)),
    /**
     * 上传图片
     */
    IM_V1_IMAGE("/im/v1/images"),
    /**
     * 发送消息
     */
    IM_V1_MESSAGES(Path.builder().appendLiteral("/im/v1/messages").append(QueryEnum.RECEIVE_ID_TYPE)),
    /**
     * 操作应用发送的（单个）消息
     */
    IM_V1_MESSAGES_MESSAGE_ID(Path.builder().appendLiteral("/im/v1/messages/").append(PathVariableEnum.MESSAGE_ID)),
    /**
     * 回复消息
     */
    IM_V1_MESSAGES_MESSAGE_ID_REPLY(
            Path.builder()
                    .appendLiteral("/im/v1/messages/")
                    .append(PathVariableEnum.MESSAGE_ID)
                    .appendLiteral("/reply")),
    /**
     * 获取消息中的资源文件
     */
    IM_V1_MESSAGES_RESOURCES(
            Path.builder()
                    .appendLiteral("/im/v1/messages/")
                    .append(PathVariableEnum.MESSAGE_ID)
                    .appendLiteral("/resources/")
                    .append(PathVariableEnum.FILE_KEY)
                    .append(QueryEnum.TYPE)),
    /**
     * 延时更新消息卡片
     */
    INTERACTIVE_V1_CARD_UPDATE("/interactive/v1/card/update"),
    /**
     * 批量发送消息
     */
    MESSAGE_V4_BATCH_SEND("/message/v4/batch_send"),
    /**
     * 获取用户或机器人所在的群列表
     */
    IM_V1_CHATS(
            Path.builder()
                    .appendLiteral("/im/v1/chats")
                    .append(QueryEnum.USER_ID_TYPE)
                    .append(QueryEnum.PAGE_TOKEN)
                    .append(QueryEnum.PAGE_SIZE)),
    /**
     * 获取群成员列表
     */
    IM_V1_CHATS_MEMBERS(
            Path.builder()
                    .appendLiteral("/im/v1/chats/")
                    .append(PathVariableEnum.CHAT_ID)
                    .appendLiteral("/members")
                    .append(QueryEnum.MEMBER_ID_TYPE)
                    .append(QueryEnum.PAGE_TOKEN)
                    .append(QueryEnum.PAGE_SIZE)),
    ;

    /**
     * 接口路径对象
     */
    @NonNull
    private final Path path;

    /**
     * @param builder 接口路径对象构建对象
     */
    OpenAPIEnum(@NonNull Path.Builder builder) {
        this(builder.build());
    }

    /**
     * @param literal 接口路径字符串
     */
    OpenAPIEnum(@NonNull String literal) {
        this(new Path(literal));
    }
}
