package cn.duskykite.open.call;

import cn.duskykite.open.Tos;
import lombok.NonNull;
import okhttp3.Headers;

import java.util.Optional;

/**
 * HTTP响应信息
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Response<T>(
        // 响应码
        int code,
        // 头部信息
        @NonNull Headers headers,
        // 响应结果
        T result
) {

    /**
     * @return 是否成功（2xx）
     */
    public boolean is2xxSuccessful() {
        return code / 100 == 2;
    }

    /**
     * 获取头部信息条目
     * @param name 条目名
     * @return 条目值
     */
    public String getHeader(@NonNull String name) {
        return headers.get(name);
    }

    /**
     * @return 内容类型
     */
    public String contentType() {
        return getHeader("Content-Type");
    }

    /**
     * @return 内容长度
     */
    public String contentLength() {
        return getHeader("Content-Length");
    }

    /**
     * @return 内容长度（数字）
     */
    public Long $contentLength() {
        return Tos.$long(contentLength());
    }

    /**
     * @return 内容处置信息
     */
    public ContentDisposition contentDisposition() {
        return Optional.ofNullable(getHeader("Content-Disposition")).map(ContentDisposition::new)
                .orElse(null);
    }
}
