package cn.duskykite.open.call;

import lombok.Getter;
import lombok.ToString;

/**
 * 飞书响应体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@ToString
@Getter
public class Result {

    /**
     * 代表业务请求成功的错误码（无错误）
     */
    public static final int SUCCESS_CODE = 0;

    /**
     * 错误码，非 0 表示失败
     */
    private Integer code;

    /**
     * 错误描述
     */
    private String msg;

    /**
     * @return 业务请求是否成功
     */
    public boolean isSuccess() {
        return SUCCESS_CODE == code;
    }
}
