package cn.duskykite.open.call.path;

import lombok.NonNull;
import org.apache.hc.core5.net.URIBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.Iterator;

/**
 * 可以直接使用的路径的处理实现类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record LiteralPathResolver(
        // 路径字符串
        @NonNull String literal
) implements PathResolver {

    @Override
    public void resolve(@NonNull URIBuilder builder, Iterator<@Nullable String> iterator) {
        PathResolver.appendPath(builder, literal());
    }
}
