package cn.duskykite.open.call.path;

import lombok.NonNull;
import org.apache.hc.core5.net.URIBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.Iterator;
import java.util.Optional;

/**
 * 路径处理对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface PathResolver {

    /**
     * 追加路径字符串
     * @param builder URI构建对象
     * @param path 待追加的路径字符串
     */
    static void appendPath(@NonNull URIBuilder builder, @NonNull String path) {
        builder.setPath(Optional.ofNullable(builder.getPath()).map(old -> old + path).orElse(path));
    }

    /**
     * 处理路径
     * @param builder URI构建对象
     * @param iterator 获取路径中待替换参数的迭代获取对象
     */
    void resolve(@NonNull URIBuilder builder, Iterator<@Nullable String> iterator);
}
