package cn.duskykite.open.call.path;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 路径中的变量的枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum PathVariableEnum implements PathVariablePathResolver {
    /**
     * 消息的ID，详情参见<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2">消息ID说明</a>
     */
    MESSAGE_ID("message_id"),
    /**
     * 文件的key，通过<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/file/create">上传文件</a>接口上传图片后获得
     */
    FILE_KEY("file_key"),
    /**
     * 部门自定义 ID（或者 openID）。不同 ID 的说明及获取方式 参见<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview#23857fe0">部门ID说明</a>
     */
    DEPARTMENT_ID("department_id"),
    /**
     * 用户ID。例如user_id_type=open_id，user_id的类型需为open_id。不同ID的说明参见 <a href="https://open.feishu.cn/document/home/user-identity-introduction/introduction">用户相关的 ID 概念</a>
     */
    USER_ID("user_id"),
    /**
     * 群 ID，详情参见<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description">群ID 说明</a>
     */
    CHAT_ID("chat_id"),
    ;

    /**
     * 路径变量值
     */
    @NonNull
    private final String variable;

    @Override
    public @NonNull String pathVariable() {
        return variable;
    }
}
