package cn.duskykite.open.call.path;

import lombok.NonNull;
import org.apache.hc.core5.net.URIBuilder;

import javax.annotation.Nullable;
import java.util.Iterator;
import java.util.Objects;

/**
 * 路径中的变量的路径处理对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface PathVariablePathResolver extends PathResolver {

    /**
     * @return 路径变量值
     */
    @NonNull String pathVariable();

    @Override
    default void resolve(
            @NonNull URIBuilder builder, Iterator<@org.checkerframework.checker.nullness.qual.Nullable String> iterator
    ) {
        @Nullable String variable = null;
        if (Objects.nonNull(iterator) && iterator.hasNext() && Objects.isNull(variable = iterator.next())) {
            return;
        }
        PathResolver.appendPath(builder, Objects.isNull(variable) ? ":" + pathVariable() : variable);
    }
}
