package cn.duskykite.open.call.path;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 路径中的查询枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum QueryEnum implements QueryPathResolver {
    /**
     * 消息接收者id类型 open_id/user_id/union_id/email/chat_id
     */
    RECEIVE_ID_TYPE("receive_id_type"),
    /**
     * 类型
     */
    TYPE("type"),
    /**
     * 用户 ID 类型 open_id/union_id/user_id
     */
    USER_ID_TYPE("user_id_type"),
    /**
     * 部门ID的类型 department_id/open_department_id
     */
    DEPARTMENT_ID_TYPE("department_id_type"),
    /**
     * 是否递归返回子（资源），默认不递归。
     */
    FETCH_CHILD("fetch_child"),
    /**
     * 分页大小
     */
    PAGE_SIZE("page_size"),
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；
     * 分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
     */
    PAGE_TOKEN("page_token"),
    /**
     * 	部门 ID
     */
    DEPARTMENT_ID("department_id"),
    /**
     * 群成员 用户 ID 类型，详情参见 <a href="https://open.feishu.cn/document/home/user-identity-introduction/introduction">用户相关的 ID 概念</a>
     */
    MEMBER_ID_TYPE("member_id_type"),
    ;

    /**
     * 查询名
     */
    @NonNull
    private final String name;

    @Override
    public @NonNull String queryName() {
        return name;
    }
}
