package cn.duskykite.open.call.path;

import lombok.NonNull;
import org.apache.hc.core5.net.URIBuilder;

import javax.annotation.Nullable;
import java.util.Iterator;
import java.util.Objects;

/**
 * 路径中的查询的路径处理对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface QueryPathResolver extends PathResolver {

    /**
     * @return 查询名
     */
    @NonNull String queryName();

    @Override
    default void resolve(
            @NonNull URIBuilder builder, Iterator<@org.checkerframework.checker.nullness.qual.Nullable String> iterator
    ) {
        @Nullable String value = null;
        if (Objects.nonNull(iterator) && iterator.hasNext() && Objects.isNull(value = iterator.next())) {
            return;
        }
        var name = queryName();
        builder.addParameter(name, Objects.isNull(value) ? ":" + name : value);
    }
}
