package cn.duskykite.open.call.requestbody;

import cn.duskykite.open.call.ContentDisposition;
import lombok.Builder;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.MultipartBody;

/**
 * 图片
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record Image(
        // 文件名
        @NonNull String filename,
        // 图片数据
        @SuppressWarnings("NullableProblems") @NonNull byte[] data,
        // 内容类型
        @NonNull String contentType
) implements MultipartBodyResolver {

    /**
     * JPEG图片内容类型
     */
    public static final MediaType IMAGE_JPEG = MediaType.parse("image/jpeg");
    /**
     * PNG图片内容类型
     */
    public static final MediaType IMAGE_PNG = MediaType.parse("image/png");

    @Override
    public void resolve(MultipartBody.@NonNull Builder builder, @NonNull String name) {
        builder.addFormDataPart(name, filename, MultipartBody.create(data, MediaType.parse(contentType)));
    }

    /**
     * 转为内容处置信息
     * @param name 模块名
     * @return 内容处置信息
     */
    public @NonNull ContentDisposition toContentDisposition(@NonNull String name) {
        return new ContentDisposition("form-data; name=\"" + name + "\"; filename=\"" + filename + "\"");
    }
}
