package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;
import okhttp3.MultipartBody;

/**
 * 图片类型
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record ImageType(
        // 值
        @NonNull String type
) implements MultipartBodyResolver {

    /**
     * 用于发送消息
     */
    public static final ImageType MESSAGE = new ImageType("message");

    /**
     * 用于设置头像
     */
    public static final ImageType AVATAR = new ImageType("avatar");

    @Override
    public void resolve(MultipartBody.@NonNull Builder builder, @NonNull String name) {
        builder.addFormDataPart(name, type);
    }
}
