package cn.duskykite.open.call.requestbody;

import cn.duskykite.open.LarkSupport;
import kotlin.Pair;
import lombok.NonNull;
import okhttp3.MultipartBody;

import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 根据对象中的（复合请求体处理对象类型的）属性执行复合请求体组装的实现类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface MultipartBodyFieldResolverGenerator extends MultipartBodySupplier {

    /**
     * 生成复合请求体处理对象的流
     * @param clz 开始提取类属性的那一层级的类对象
     * @param obj 提取属性值的对象
     * @return 复合请求体处理对象的流
     */
    static @NonNull Stream<Pair<String, MultipartBodyResolver>> toResolverStream(
            @NonNull Class<?> clz, Object obj
    ) {
        var fields = clz.getDeclaredFields();
        var stream = Arrays.stream(fields).<Pair<String, MultipartBodyResolver>>mapMulti((field, downstream) -> {
            if (field.trySetAccessible()) {
                @Nullable Object value;
                try {
                    value = field.get(obj);
                } catch (IllegalAccessException ignored) {
                    return;
                }

                if (value instanceof MultipartBodyResolver resolver) {
                    downstream.accept(new Pair<>(
                            Objects.requireNonNull(LarkSupport.FIELD_NAMING_MAPPER.apply(field)),
                            resolver));
                }
            }
        });

        // 父级
        @Nullable var superclass = clz.getSuperclass();
        if (Objects.isNull(superclass) || Objects.class.equals(superclass)) {
            return stream;
        }

        var superstream = toResolverStream(superclass, obj);
        return Stream.concat(superstream, stream);
    }

    @Override
    default @NonNull MultipartBody get() {
        var builder = new MultipartBody.Builder().setType(type());
        toResolverStream(this.getClass(), this).collect(Collectors.toMap(
                        Pair<String, MultipartBodyResolver>::component1,
                        Pair<String, MultipartBodyResolver>::component2,
                        (old, latter) -> latter))
                .forEach((name, resolver) -> resolver.resolve(builder, name));
        return builder.build();
    }
}
