package cn.duskykite.open.call.requestbody;

import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.MultipartBody;

import java.util.function.Supplier;

/**
 * 复合请求体提供方法
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface MultipartBodySupplier extends Supplier<MultipartBody> {

    /**
     * @return 复合请求体的内容类型
     */
    @NonNull MediaType type();

    /**
     * 获取复合请求体
     * @return 复合请求体
     */
    @NonNull MultipartBody get();
}
